/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.key.ObjectID;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.UriUtils;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Complex;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Provider;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.DefaultStateCache;
import org.aoju.bus.oauth.metric.StateCache;

public abstract class DefaultProvider
implements Provider {
    private static final String ALGORITHM = "HmacSHA256";
    protected Context context;
    protected Complex source;
    protected StateCache stateCache;

    public DefaultProvider(Context context, Complex source) {
        this(context, source, DefaultStateCache.INSTANCE);
    }

    public DefaultProvider(Context context, Complex source, StateCache stateCache) {
        this.context = context;
        this.source = source;
        this.stateCache = stateCache;
        if (!DefaultProvider.isSupportedAuth(context, source)) {
            throw new InstrumentException(Builder.Status.PARAMETER_INCOMPLETE.getCode());
        }
        DefaultProvider.checkcontext(context, source);
    }

    public static String generateDingTalkSignature(String secretKey, String timestamp) {
        byte[] signData = DefaultProvider.sign(secretKey.getBytes(Charset.UTF_8), timestamp.getBytes(Charset.UTF_8));
        return DefaultProvider.urlEncode(new String(Base64.encode(signData, false)));
    }

    private static byte[] sign(byte[] key, byte[] data) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(key, ALGORITHM));
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InstrumentException("Unsupported algorithm: HmacSHA256", ex);
        }
        catch (InvalidKeyException ex) {
            throw new InstrumentException("Invalid key: " + Arrays.toString(key), ex);
        }
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, Charset.UTF_8.displayName());
            return encoded.replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
        }
        catch (UnsupportedEncodingException e) {
            throw new InstrumentException("Failed To Encode Uri", e);
        }
    }

    public static String urlDecode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLDecoder.decode(value, Charset.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new InstrumentException("Failed To Decode Uri", e);
        }
    }

    public static Map<String, String> parseStringToMap(String accessTokenStr) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (accessTokenStr.contains("&")) {
            String[] fields;
            for (String field : fields = accessTokenStr.split("&")) {
                if (!field.contains("=")) continue;
                String[] keyValue = field.split("=");
                res.put(DefaultProvider.urlDecode(keyValue[0]), keyValue.length == 2 ? DefaultProvider.urlDecode(keyValue[1]) : null);
            }
        }
        return res;
    }

    public static Map<String, Object> parseQueryToMap(String url) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UriUtils.decodeVal(url, "UTF-8").forEach(paramMap::put);
        return paramMap;
    }

    public static boolean isHttpProtocol(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("http://");
    }

    public static boolean isHttpsProtocol(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("https://");
    }

    public static boolean isLocalHost(String url) {
        return StringUtils.isEmpty(url) || url.contains("127.0.0.1") || url.contains("localhost");
    }

    public static String generateElemeSignature(String appKey, String secret, long timestamp, String action, String token, Map<String, Object> parameters) {
        TreeMap<String, Object> sorted = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            sorted.put(entry.getKey(), entry.getValue());
        }
        sorted.put("app_key", appKey);
        sorted.put("timestamp", timestamp);
        StringBuffer string = new StringBuffer();
        for (Map.Entry entry : sorted.entrySet()) {
            string.append((String)entry.getKey()).append("=").append(JSON.toJSONString(entry.getValue()));
        }
        String string2 = String.format("%s%s%s%s", action, token, string, secret);
        String string3 = DefaultProvider.md5(string2);
        return string3.toUpperCase();
    }

    private static String md5(String str) {
        StringBuilder buffer = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] byteData = md.digest();
            buffer = new StringBuilder();
            for (byte byteDatum : byteData) {
                buffer.append(Integer.toString((byteDatum & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null == buffer ? "" : buffer.toString();
    }

    public static boolean isSupportedAuth(Context context, Complex source) {
        boolean isSupported;
        boolean bl = isSupported = StringUtils.isNotEmpty(context.getClientId()) && StringUtils.isNotEmpty(context.getClientSecret()) && StringUtils.isNotEmpty(context.getRedirectUri());
        if (isSupported && Registry.ALIPAY == source) {
            isSupported = StringUtils.isNotEmpty(context.getAlipayPublicKey());
        }
        if (isSupported && Registry.STACK == source) {
            isSupported = StringUtils.isNotEmpty(context.getStackOverflowKey());
        }
        if (isSupported && Registry.WECHAT_EE == source) {
            isSupported = StringUtils.isNotEmpty(context.getAgentId());
        }
        return isSupported;
    }

    public static void checkcontext(Context context, Complex source) {
        String redirectUri = context.getRedirectUri();
        if (!DefaultProvider.isHttpProtocol(redirectUri) && !DefaultProvider.isHttpsProtocol(redirectUri)) {
            throw new InstrumentException(Builder.Status.ILLEGAL_REDIRECT_URI.getCode());
        }
        if (Registry.FACEBOOK == source && !DefaultProvider.isHttpsProtocol(redirectUri)) {
            throw new InstrumentException(Builder.Status.ILLEGAL_REDIRECT_URI.getCode());
        }
        if (Registry.ALIPAY == source && DefaultProvider.isLocalHost(redirectUri)) {
            throw new InstrumentException(Builder.Status.ILLEGAL_REDIRECT_URI.getCode());
        }
    }

    public static void checkCode(Complex complex, Callback callback) {
        String code = callback.getCode();
        if (complex == Registry.ALIPAY) {
            code = callback.getAuth_code();
        } else if (complex == Registry.HUAWEI) {
            code = callback.getAuthorization_code();
        }
        if (StringUtils.isEmpty(code)) {
            throw new InstrumentException(Builder.Status.ILLEGAL_CODE.getCode());
        }
    }

    protected abstract AccToken getAccessToken(Callback var1);

    protected abstract Object getUserInfo(AccToken var1);

    @Override
    public Message login(Callback Callback2) {
        try {
            DefaultProvider.checkCode(this.source, Callback2);
            this.checkState(Callback2.getState());
            AccToken token = this.getAccessToken(Callback2);
            Property user = (Property)this.getUserInfo(token);
            return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(user).build();
        }
        catch (Exception e) {
            return this.responseError(e);
        }
    }

    private Message responseError(Exception e) {
        String errorCode = "" + Builder.Status.FAILURE.getCode();
        if (e instanceof InstrumentException) {
            errorCode = ((InstrumentException)e).getErrcode();
        }
        return Message.builder().errcode(errorCode).errmsg(e.getMessage()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getClientId()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    protected String accessTokenUrl(String code) {
        return Builder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.context.getClientId()).queryParam("client_secret", this.context.getClientSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromBaseUrl(this.source.refresh()).queryParam("client_id", this.context.getClientId()).queryParam("client_secret", this.context.getClientSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).build();
    }

    protected String revokeUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.revoke()).queryParam("access_token", token.getAccessToken()).build();
    }

    protected String getRealState(String state) {
        if (StringUtils.isEmpty(state)) {
            state = ObjectID.id();
        }
        this.stateCache.cache(state, state);
        return state;
    }

    protected String doPostAuthorizationCode(String code) {
        return HttpClient.post(this.accessTokenUrl(code));
    }

    protected String doGetAuthorizationCode(String code) {
        return HttpClient.get(this.accessTokenUrl(code));
    }

    protected String doGetUserInfo(AccToken token) {
        return HttpClient.get(this.userInfoUrl(token));
    }

    protected String doGetRevoke(AccToken token) {
        return HttpClient.get(this.revokeUrl(token));
    }

    protected void checkState(String state) {
        if (StringUtils.isEmpty(state) || !this.stateCache.containsKey(state)) {
            throw new InstrumentException("" + (Object)((Object)Builder.Status.ILLEGAL_REQUEST));
        }
    }
}

