/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.druid;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.druid.DataSourceHolder;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final Set<Object> keySet = new LinkedHashSet<Object>();
    private static DynamicDataSource instance;
    private static byte[] lock;

    public void setTargetDataSources(Map<Object, Object> map) {
        super.setTargetDataSources(map);
        keySet.add(map.keySet());
        this.afterPropertiesSet();
    }

    protected Object determineCurrentLookupKey() {
        String key = DataSourceHolder.getKey();
        if (!keySet.contains(key)) {
            this.logger.info((Object)String.format("can not found datasource by key: '%s',this session may use default datasource", key));
        }
        if (key == null) {
            Logger.info("The current datasource key \uff1a{}", "dataSource");
        } else {
            Logger.info("The current datasource key \uff1a{}", key);
        }
        return key;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        try {
            Field sourceMapField = AbstractRoutingDataSource.class.getDeclaredField("resolvedDataSources");
            sourceMapField.setAccessible(true);
            Map sourceMap = (Map)sourceMapField.get((Object)this);
            keySet.addAll(sourceMap.keySet());
            sourceMapField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InstrumentException(e);
        }
    }

    public boolean containsKey(String key) {
        return keySet.contains(key);
    }

    public DataSource getDefaultDataSource() {
        return super.determineTargetDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized DynamicDataSource getInstance() {
        if (instance != null) return instance;
        byte[] byArray = lock;
        synchronized (lock) {
            if (instance != null) return instance;
            instance = new DynamicDataSource();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void addDataSource(String key, DataSource dataSource) {
        if (dataSource != null && dataSource instanceof AbstractRoutingDataSource) {
            try {
                Field sourceMapField = AbstractRoutingDataSource.class.getDeclaredField("resolvedDataSources");
                sourceMapField.setAccessible(true);
                Map sourceMap = (Map)sourceMapField.get(DynamicDataSource.getInstance().getDefaultDataSource());
                sourceMap.put(key, dataSource);
                keySet.add(key);
                sourceMapField.setAccessible(false);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        lock = new byte[0];
    }
}

