/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.reader;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.Manage;
import org.aoju.bus.cache.Provider;
import org.aoju.bus.cache.entity.CacheHolder;
import org.aoju.bus.cache.entity.CacheKeys;
import org.aoju.bus.cache.entity.CacheMethod;
import org.aoju.bus.cache.proxy.ProxyChain;
import org.aoju.bus.cache.reader.AbstractReader;
import org.aoju.bus.cache.support.Addables;
import org.aoju.bus.cache.support.KeyGenerator;
import org.aoju.bus.cache.support.KeyValueUtils;
import org.aoju.bus.cache.support.PatternGenerator;
import org.aoju.bus.cache.support.PreventObjects;
import org.aoju.bus.core.annotation.Inject;
import org.aoju.bus.core.annotation.Singleton;
import org.aoju.bus.logger.Logger;

@Singleton
public class MultiCacheReader
extends AbstractReader {
    @Inject
    private Manage cacheManager;
    @Inject
    private Context config;
    @Inject(optional=true)
    private Provider baseProvider;

    private static Map mergeMap(Class<?> resultMapType, Map proceedEntryValueMap, Map<String, Object> key2MultiEntry, Map<String, Object> hitKeyValueMap) {
        Map resultMap = Addables.newMap(resultMapType, proceedEntryValueMap);
        MultiCacheReader.mergeCacheValueToResultMap(resultMap, hitKeyValueMap, key2MultiEntry);
        return resultMap;
    }

    private static Map toMap(Class<?> resultMapType, Map<String, Object> key2MultiEntry, Map<String, Object> hitKeyValueMap) {
        Map resultMap = Addables.newMap(resultMapType, null);
        MultiCacheReader.mergeCacheValueToResultMap(resultMap, hitKeyValueMap, key2MultiEntry);
        return resultMap;
    }

    private static void mergeCacheValueToResultMap(Map resultMap, Map<String, Object> hitKeyValueMap, Map<String, Object> key2MultiEntry) {
        for (Map.Entry<String, Object> entry : hitKeyValueMap.entrySet()) {
            Object inCacheValue = entry.getValue();
            if (PreventObjects.isPrevent(inCacheValue)) continue;
            String cacheKey = entry.getKey();
            Object multiArgEntry = key2MultiEntry.get(cacheKey);
            resultMap.put(multiArgEntry, inCacheValue);
        }
    }

    private static Collection mergeCollection(Class<?> collectionType, Collection proceedCollection, Map<String, Object> hitKeyValueMap) {
        Collection resultCollection = Addables.newCollection(collectionType, proceedCollection);
        MultiCacheReader.mergeCacheValueToResultCollection(resultCollection, hitKeyValueMap);
        return resultCollection;
    }

    private static Collection toCollection(Class<?> collectionType, Map<String, Object> hitKeyValueMap) {
        Collection resultCollection = Addables.newCollection(collectionType, null);
        MultiCacheReader.mergeCacheValueToResultCollection(resultCollection, hitKeyValueMap);
        return resultCollection;
    }

    private static void mergeCacheValueToResultCollection(Collection resultCollection, Map<String, Object> hitKeyValueMap) {
        for (Object inCacheValue : hitKeyValueMap.values()) {
            if (PreventObjects.isPrevent(inCacheValue)) continue;
            resultCollection.add(inCacheValue);
        }
    }

    @Override
    public Object read(CacheHolder cacheHolder, CacheMethod cacheMethod, ProxyChain baseInvoker, boolean needWrite) throws Throwable {
        Object result;
        Map[] pair = KeyGenerator.generateMultiKey(cacheHolder, baseInvoker.getArgs());
        Map key2MultiEntry = pair[1];
        Set<String> keys = key2MultiEntry.keySet();
        CacheKeys cacheKeys = this.cacheManager.readBatch(cacheHolder.getCache(), keys);
        this.doRecord(cacheKeys, cacheHolder);
        if (!cacheKeys.getMissKeySet().isEmpty()) {
            result = this.handlePartHit(baseInvoker, cacheKeys, cacheHolder, cacheMethod, pair, needWrite);
        } else {
            Map<String, Object> keyValueMap = cacheKeys.getHitKeyMap();
            result = this.handleFullHit(baseInvoker, keyValueMap, cacheMethod, key2MultiEntry);
        }
        return result;
    }

    private Object handlePartHit(ProxyChain baseInvoker, CacheKeys cacheKeys, CacheHolder cacheHolder, CacheMethod cacheMethod, Map[] pair, boolean needWrite) throws Throwable {
        Object result;
        Map multiEntry2Key = pair[0];
        Map key2MultiEntry = pair[1];
        Set<String> missKeys = cacheKeys.getMissKeySet();
        Map<String, Object> hitKeyValueMap = cacheKeys.getHitKeyMap();
        Object[] missArgs = this.toMissArgs(missKeys, key2MultiEntry, baseInvoker.getArgs(), cacheHolder.getMultiIndex());
        Object proceed = this.doLogInvoke(() -> baseInvoker.proceed(missArgs));
        if (proceed != null) {
            Class<?> returnType = proceed.getClass();
            cacheMethod.setReturnType(returnType);
            if (Map.class.isAssignableFrom(returnType)) {
                Map proceedEntryValueMap = (Map)proceed;
                if (needWrite) {
                    Map<String, Object> keyValueMap = KeyValueUtils.mapToKeyValue(proceedEntryValueMap, missKeys, multiEntry2Key, this.config.getPrevent());
                    this.cacheManager.writeBatch(cacheHolder.getCache(), keyValueMap, cacheHolder.getExpire());
                }
                result = MultiCacheReader.mergeMap(returnType, proceedEntryValueMap, key2MultiEntry, hitKeyValueMap);
            } else {
                Collection proceedCollection = this.asCollection(proceed, returnType);
                if (needWrite) {
                    Map<String, Object> keyValueMap = KeyValueUtils.collectionToKeyValue(proceedCollection, cacheHolder.getId(), missKeys, multiEntry2Key, this.config.getPrevent());
                    this.cacheManager.writeBatch(cacheHolder.getCache(), keyValueMap, cacheHolder.getExpire());
                }
                Collection resultCollection = MultiCacheReader.mergeCollection(returnType, proceedCollection, hitKeyValueMap);
                result = this.asType(resultCollection, returnType);
            }
        } else {
            result = this.handleFullHit(baseInvoker, hitKeyValueMap, cacheMethod, key2MultiEntry);
        }
        return result;
    }

    private Object asType(Collection collection, Class<?> returnType) {
        if (Collection.class.isAssignableFrom(returnType)) {
            return collection;
        }
        return collection.toArray();
    }

    private Collection asCollection(Object proceed, Class<?> returnType) {
        if (Collection.class.isAssignableFrom(returnType)) {
            return (Collection)proceed;
        }
        return Arrays.asList((Object[])proceed);
    }

    private Object handleFullHit(ProxyChain baseInvoker, Map<String, Object> keyValueMap, CacheMethod cacheMethod, Map<String, Object> key2Id) throws Throwable {
        Object result;
        Class<?> returnType = cacheMethod.getReturnType();
        if (returnType == null) {
            result = this.doLogInvoke(baseInvoker::proceed);
            if (result != null) {
                cacheMethod.setReturnType(result.getClass());
            }
        } else {
            result = cacheMethod.isCollection() ? MultiCacheReader.toCollection(returnType, keyValueMap) : MultiCacheReader.toMap(returnType, key2Id, keyValueMap);
        }
        return result;
    }

    private Object[] toMissArgs(Set<String> missKeys, Map<String, Object> keyIdMap, Object[] args, int multiIndex) {
        List<Object> missedMultiEntries = missKeys.stream().map(keyIdMap::get).collect(Collectors.toList());
        Class<?> multiArgType = args[multiIndex].getClass();
        Addables.Addable addable = Addables.newAddable(multiArgType, missedMultiEntries.size());
        args[multiIndex] = addable.addAll(missedMultiEntries).getResult();
        return args;
    }

    private void doRecord(CacheKeys cacheKeys, CacheHolder cacheHolder) {
        Set<String> missKeys = cacheKeys.getMissKeySet();
        int hitCount = cacheKeys.getHitKeyMap().size();
        int totalCount = hitCount + missKeys.size();
        Logger.info("multi cache hit rate: {}/{}, missed keys: {}", hitCount, totalCount, missKeys);
        if (this.baseProvider != null) {
            String pattern = PatternGenerator.generatePattern(cacheHolder);
            this.baseProvider.hitIncr(pattern, hitCount);
            this.baseProvider.reqIncr(pattern, totalCount);
        }
    }
}

