/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.Keys;

public class Sign
extends Keys<Sign> {
    protected Signature signature;

    public Sign(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public Sign(String algorithm, String privateKey, String publicKey) {
        this(algorithm, Builder.decode(privateKey), Builder.decode(publicKey));
    }

    public Sign(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public Sign(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, Builder.generatePrivateKey(algorithm, privateKey), Builder.generatePublicKey(algorithm, publicKey));
    }

    public Sign(String algorithm, KeyPair keyPair) {
        this(algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    @Override
    public Sign init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        try {
            this.signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
        super.init(algorithm, privateKey, publicKey);
        return this;
    }

    public Sign setParameter(AlgorithmParameterSpec params) {
        try {
            this.signature.setParameter(params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    public byte[] sign(byte[] data) {
        this.lock.lock();
        try {
            this.signature.initSign(this.privateKey);
            this.signature.update(data);
            byte[] byArray = this.signature.sign();
            return byArray;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        this.lock.lock();
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(data);
            boolean bl = this.signature.verify(sign);
            return bl;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Sign setSignature(Signature signature) {
        this.signature = signature;
        return this;
    }

    public Sign setCertificate(Certificate certificate) {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && CollUtils.isNotEmpty(critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) && critSet.contains("2.5.29.15") && (keyUsageInfo = cert.getKeyUsage()) != null && !keyUsageInfo[0]) {
            throw new InstrumentException("Wrong key usage");
        }
        this.publicKey = certificate.getPublicKey();
        return this;
    }
}

