/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.office.Manager;
import org.aoju.bus.office.Standard;
import org.aoju.bus.office.magic.Formats;
import org.aoju.bus.office.registry.DefaultFormatRegistry;
import org.aoju.bus.office.registry.FormatRegistry;

public class Converter {
    private final Manager officeManager;
    private final FormatRegistry formatRegistry;
    private Map<String, ?> defaultLoadProperties = this.createDefaultLoadProperties();

    public Converter(Manager officeManager) {
        this(officeManager, new DefaultFormatRegistry());
    }

    public Converter(Manager officeManager, FormatRegistry formatRegistry) {
        this.officeManager = officeManager;
        this.formatRegistry = formatRegistry;
    }

    private Map<String, Object> createDefaultLoadProperties() {
        HashMap<String, Object> loadProperties = new HashMap<String, Object>();
        loadProperties.put("Hidden", true);
        loadProperties.put("ReadOnly", true);
        loadProperties.put("UpdateDocMode", (short)1);
        return loadProperties;
    }

    public void setDefaultLoadProperties(Map<String, ?> defaultLoadProperties) {
        this.defaultLoadProperties = defaultLoadProperties;
    }

    public FormatRegistry getFormatRegistry() {
        return this.formatRegistry;
    }

    public void convert(File inputFile, File outputFile) throws InstrumentException {
        String outputExtension = FileUtils.getExtension(outputFile.getName());
        Formats outputFormat = this.formatRegistry.getFormatByExtension(outputExtension);
        this.convert(inputFile, outputFile, outputFormat);
    }

    public void convert(File inputFile, File outputFile, Formats outputFormat) throws InstrumentException {
        String inputExtension = FileUtils.getExtension(inputFile.getName());
        Formats inputFormat = this.formatRegistry.getFormatByExtension(inputExtension);
        Standard conversionTask = new Standard(inputFile, outputFile, outputFormat);
        conversionTask.setDefaultLoadProperties(this.defaultLoadProperties);
        conversionTask.setInputFormat(inputFormat);
        this.officeManager.execute(conversionTask);
    }
}

