/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office;

import org.aoju.bus.core.lang.exception.InstrumentException;

public abstract class Retryable {
    protected abstract void attempt() throws InstrumentException, Exception;

    public void execute(long interval, long timeout) throws Exception {
        this.execute(0L, interval, timeout);
    }

    public void execute(long delay, long interval, long timeout) throws Exception {
        long start = System.currentTimeMillis();
        if (delay > 0L) {
            this.sleep(delay);
        }
        while (true) {
            try {
                this.attempt();
                return;
            }
            catch (InstrumentException e) {
                if (System.currentTimeMillis() - start < timeout) {
                    this.sleep(interval);
                    continue;
                }
                throw new InstrumentException(e.getCause());
            }
            break;
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

