/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.office.process.ProcessManager;
import org.aoju.bus.office.support.ProcessQuery;

public class LinuxProcessManager
implements ProcessManager {
    private static final Pattern PS_OUTPUT_LINE = Pattern.compile("^\\s*(\\d+)\\s+(.*)$");
    private String[] runAsArgs;

    public void setRunAsArgs(String ... runAsArgs) {
        this.runAsArgs = runAsArgs;
    }

    protected String[] psCommand() {
        return new String[]{"/bin/ps", "-e", "-o", "pid,args"};
    }

    @Override
    public long findPid(ProcessQuery query) throws IOException {
        String regex = Pattern.quote(query.getCommand()) + ".*" + Pattern.quote(query.getArgument());
        Pattern commandPattern = Pattern.compile(regex);
        for (String line : this.execute(this.psCommand())) {
            String command;
            Matcher commandMatcher;
            Matcher lineMatcher = PS_OUTPUT_LINE.matcher(line);
            if (!lineMatcher.matches() || !(commandMatcher = commandPattern.matcher(command = lineMatcher.group(2))).find()) continue;
            return Long.parseLong(lineMatcher.group(1));
        }
        return -2L;
    }

    @Override
    public void kill(Process process, long pid) throws IOException {
        if (pid <= 0L) {
            throw new IllegalArgumentException("invalid pid: " + pid);
        }
        this.execute("/bin/kill", "-KILL", Long.toString(pid));
    }

    private List<String> execute(String ... args) throws IOException {
        String[] command;
        if (this.runAsArgs != null) {
            command = new String[this.runAsArgs.length + args.length];
            System.arraycopy(this.runAsArgs, 0, command, 0, this.runAsArgs.length);
            System.arraycopy(args, 0, command, this.runAsArgs.length, args.length);
        } else {
            command = args;
        }
        Process process = new ProcessBuilder(command).start();
        return IoUtils.readLines(process.getInputStream(), "UTF-8", new ArrayList());
    }
}

