/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.registry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aoju.bus.office.magic.Formats;
import org.aoju.bus.office.registry.FormatRegistry;

public class SimpleFormatRegistry
implements FormatRegistry {
    private List<Formats> documents = new ArrayList<Formats>();

    public void addFormat(Formats document) {
        this.documents.add(document);
    }

    @Override
    public Formats getFormatByExtension(String extension) {
        if (extension == null) {
            return null;
        }
        String lowerExtension = extension.toLowerCase();
        for (Formats format : this.documents) {
            if (!format.getExtension().equals(lowerExtension)) continue;
            return format;
        }
        return null;
    }

    @Override
    public Formats getFormatByMediaType(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        for (Formats format : this.documents) {
            if (!format.getMediaType().equals(mediaType)) continue;
            return format;
        }
        return null;
    }

    @Override
    public Set<Formats> getOutputFormats(Formats.Type family) {
        HashSet<Formats> formats = new HashSet<Formats>();
        for (Formats format : this.documents) {
            if (format.getStoreProperties(family) == null) continue;
            formats.add(format);
        }
        return formats;
    }
}

