/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support;

import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Manager;
import org.aoju.bus.office.Office;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.support.PooledManager;
import org.aoju.bus.office.support.PooledSettings;

class ProcessManager
implements Manager {
    private final BlockingQueue<PooledManager> pool;
    private final PooledManager[] pooledManagers;
    private final long taskQueueTimeout;
    private final Logger logger = Logger.getLogger(ProcessManager.class.getName());
    private volatile boolean running = false;

    public ProcessManager(File officeHome, UnoUrl[] unoUrls, String[] runAsArgs, File templateProfileDir, File workDir, long retryTimeout, long taskQueueTimeout, long taskExecutionTimeout, int maxTasksPerProcess, org.aoju.bus.office.process.ProcessManager processManager) {
        this.taskQueueTimeout = taskQueueTimeout;
        this.pool = new ArrayBlockingQueue<PooledManager>(unoUrls.length);
        this.pooledManagers = new PooledManager[unoUrls.length];
        for (int i = 0; i < unoUrls.length; ++i) {
            PooledSettings settings = new PooledSettings(unoUrls[i]);
            settings.setRunAsArgs(runAsArgs);
            settings.setTemplateProfileDir(templateProfileDir);
            settings.setWorkDir(workDir);
            settings.setOfficeHome(officeHome);
            settings.setRetryTimeout(retryTimeout);
            settings.setTaskExecutionTimeout(taskExecutionTimeout);
            settings.setMaxTasksPerProcess(maxTasksPerProcess);
            settings.setProcessManager(processManager);
            this.pooledManagers[i] = new PooledManager(settings);
        }
        this.logger.info("ProcessManager implementation is " + processManager.getClass().getSimpleName());
    }

    @Override
    public synchronized void start() throws InstrumentException {
        for (int i = 0; i < this.pooledManagers.length; ++i) {
            this.pooledManagers[i].start();
            this.releaseManager(this.pooledManagers[i]);
        }
        this.running = true;
    }

    @Override
    public void execute(Office task) throws IllegalStateException, InstrumentException {
        if (!this.running) {
            throw new IllegalStateException("this OfficeManager is currently stopped");
        }
        PooledManager manager = null;
        try {
            manager = this.acquireManager();
            if (manager == null) {
                throw new InstrumentException("no office manager available");
            }
            manager.execute(task);
        }
        finally {
            if (manager != null) {
                this.releaseManager(manager);
            }
        }
    }

    @Override
    public synchronized void stop() throws InstrumentException {
        this.running = false;
        this.logger.info("stopping");
        this.pool.clear();
        for (int i = 0; i < this.pooledManagers.length; ++i) {
            this.pooledManagers[i].stop();
        }
        this.logger.info("stopped");
    }

    private PooledManager acquireManager() {
        try {
            return this.pool.poll(this.taskQueueTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new InstrumentException("interrupted", interruptedException);
        }
    }

    private void releaseManager(PooledManager manager) {
        try {
            this.pool.put(manager);
        }
        catch (InterruptedException interruptedException) {
            throw new InstrumentException("interrupted", interruptedException);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

