/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.factory.javassist;

import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.proxy.Interceptor;
import org.aoju.bus.proxy.Invoker;
import org.aoju.bus.proxy.Provider;
import org.aoju.bus.proxy.aspects.Aspect;
import org.aoju.bus.proxy.factory.AbstractFactory;
import org.aoju.bus.proxy.factory.AbstractProxyClass;
import org.aoju.bus.proxy.factory.ProxyClassCache;
import org.aoju.bus.proxy.factory.javassist.JavassistInvocation;
import org.aoju.bus.proxy.factory.javassist.JavassistUtils;
import org.aoju.bus.proxy.intercept.JavassistInterceptor;

public class JavassistFactory
extends AbstractFactory {
    private static final ProxyClassCache delegatingProxyClassCache = new ProxyClassCache(new DelegatingProxyClassGenerator());
    private static final ProxyClassCache interceptorProxyClassCache = new ProxyClassCache(new InterceptorProxyClassGenerator());
    private static final ProxyClassCache invocationHandlerProxyClassCache = new ProxyClassCache(new InvokerProxyClassGenerator());

    @Override
    public <T> T proxy(T target, Aspect aspect) {
        return JavassistFactory.newProxyInstance(target.getClass().getClassLoader(), new JavassistInterceptor(target, aspect), target.getClass().getInterfaces());
    }

    @Override
    public Object createDelegatorProxy(ClassLoader classLoader, Provider targetProvider, Class[] proxyClasses) {
        try {
            Class clazz = delegatingProxyClassCache.getProxyClass(classLoader, proxyClasses);
            return clazz.getConstructor(Provider.class).newInstance(targetProvider);
        }
        catch (Exception e) {
            throw new InstrumentException("Unable to instantiate proxy from generated proxy class.", e);
        }
    }

    @Override
    public Object createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class[] proxyClasses) {
        try {
            Class clazz = interceptorProxyClassCache.getProxyClass(classLoader, proxyClasses);
            Method[] methods = AbstractProxyClass.getImplementationMethods(proxyClasses);
            return clazz.getConstructor(Method[].class, Object.class, Interceptor.class).newInstance(methods, target, interceptor);
        }
        catch (Exception e) {
            throw new InstrumentException("Unable to instantiate proxy class instance.", e);
        }
    }

    @Override
    public Object createInvokerProxy(ClassLoader classLoader, Invoker invoker, Class[] proxyClasses) {
        try {
            Class clazz = invocationHandlerProxyClassCache.getProxyClass(classLoader, proxyClasses);
            Method[] methods = AbstractProxyClass.getImplementationMethods(proxyClasses);
            return clazz.getConstructor(Method[].class, Invoker.class).newInstance(methods, invoker);
        }
        catch (Exception e) {
            throw new InstrumentException("Unable to instantiate proxy from generated proxy class.", e);
        }
    }

    private static class DelegatingProxyClassGenerator
    extends AbstractProxyClass {
        private DelegatingProxyClassGenerator() {
        }

        @Override
        public Class createProxy(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistUtils.createClass(AbstractFactory.getSuperclass(proxyClasses));
                JavassistUtils.addField(Provider.class, "provider", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistUtils.resolve(new Class[]{Provider.class}), proxyClass);
                proxyConstructor.setBody("{ this.provider = $1; }");
                proxyClass.addConstructor(proxyConstructor);
                JavassistUtils.addInterfaces(proxyClass, JavassistFactory.toInterfaces(proxyClasses));
                Method[] methods = DelegatingProxyClassGenerator.getImplementationMethods(proxyClasses);
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    CtMethod ctMethod = new CtMethod(JavassistUtils.resolve(method.getReturnType()), method.getName(), JavassistUtils.resolve(method.getParameterTypes()), proxyClass);
                    String body = "{ return ( $r ) ( ( " + method.getDeclaringClass().getName() + " )provider.getObject() )." + method.getName() + "($$); }";
                    ctMethod.setBody(body);
                    proxyClass.addMethod(ctMethod);
                }
                return proxyClass.toClass(classLoader, null);
            }
            catch (CannotCompileException e) {
                throw new InstrumentException("Could not compile class.", e);
            }
        }
    }

    private static class InterceptorProxyClassGenerator
    extends AbstractProxyClass {
        private InterceptorProxyClassGenerator() {
        }

        @Override
        public Class createProxy(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistUtils.createClass(AbstractFactory.getSuperclass(proxyClasses));
                Method[] methods = InterceptorProxyClassGenerator.getImplementationMethods(proxyClasses);
                JavassistUtils.addInterfaces(proxyClass, JavassistFactory.toInterfaces(proxyClasses));
                JavassistUtils.addField(Method[].class, "methods", proxyClass);
                JavassistUtils.addField(Object.class, "target", proxyClass);
                JavassistUtils.addField(Interceptor.class, "intercept", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistUtils.resolve(new Class[]{Method[].class, Object.class, Interceptor.class}), proxyClass);
                proxyConstructor.setBody("{\n\tthis.methods = $1;\n\tthis.target = $2;\n\tthis.intercept = $3; }");
                proxyClass.addConstructor(proxyConstructor);
                for (int i = 0; i < methods.length; ++i) {
                    CtMethod method = new CtMethod(JavassistUtils.resolve(methods[i].getReturnType()), methods[i].getName(), JavassistUtils.resolve(methods[i].getParameterTypes()), proxyClass);
                    Class invocationClass = JavassistInvocation.getMethodInvocationClass(classLoader, methods[i]);
                    String body = "{\n\t return ( $r ) intercept.intercept( new " + invocationClass.getName() + "( methods[" + i + "], target, $args ) );\n }";
                    method.setBody(body);
                    proxyClass.addMethod(method);
                }
                return proxyClass.toClass(classLoader, null);
            }
            catch (CannotCompileException e) {
                throw new InstrumentException("Could not compile class.", e);
            }
        }
    }

    private static class InvokerProxyClassGenerator
    extends AbstractProxyClass {
        private InvokerProxyClassGenerator() {
        }

        @Override
        public Class createProxy(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistUtils.createClass(AbstractFactory.getSuperclass(proxyClasses));
                Method[] methods = InvokerProxyClassGenerator.getImplementationMethods(proxyClasses);
                JavassistUtils.addInterfaces(proxyClass, JavassistFactory.toInterfaces(proxyClasses));
                JavassistUtils.addField(Method[].class, "methods", proxyClass);
                JavassistUtils.addField(Invoker.class, "invoker", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistUtils.resolve(new Class[]{Method[].class, Invoker.class}), proxyClass);
                proxyConstructor.setBody("{\n\tthis.methods = $1;\n\tthis.invoker = $2; }");
                proxyClass.addConstructor(proxyConstructor);
                for (int i = 0; i < methods.length; ++i) {
                    CtMethod method = new CtMethod(JavassistUtils.resolve(methods[i].getReturnType()), methods[i].getName(), JavassistUtils.resolve(methods[i].getParameterTypes()), proxyClass);
                    String body = "{\n\t return ( $r ) invoker.invoke( this, methods[" + i + "], $args );\n }";
                    method.setBody(body);
                    proxyClass.addMethod(method);
                }
                return proxyClass.toClass(classLoader, null);
            }
            catch (CannotCompileException e) {
                throw new InstrumentException("Could not compile class.", e);
            }
        }
    }
}

