/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.netty.ChannelInitializer;

public class SocketServer
implements Runnable {
    private int port;
    private int bossGroupThreads;
    private int workerGroupThreads;
    private String endPoint;

    public SocketServer(int port, int bossGroupThreads, int workerGroupThreads, String endPoint) {
        this.port = port;
        this.bossGroupThreads = bossGroupThreads;
        this.workerGroupThreads = workerGroupThreads;
        this.endPoint = endPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this.bossGroupThreads);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this.workerGroupThreads);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer(this.endPoint)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture f = b.bind(this.port).sync();
            Logger.info("WebSocket Server was open: {}", this.port);
            f.channel().closeFuture().sync();
        }
        catch (Exception e) {
            try {
                Logger.error("WebSocket Server exception: {}", e.getMessage(), e);
            }
            catch (Throwable throwable) {
                workerGroup.shutdownGracefully();
                bossGroup.shutdownGracefully();
                Logger.info("WebSocket Server was closed: {}", this.port);
                throw throwable;
            }
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
            Logger.info("WebSocket Server was closed: {}", this.port);
        }
        workerGroup.shutdownGracefully();
        bossGroup.shutdownGracefully();
        Logger.info("WebSocket Server was closed: {}", this.port);
    }
}

