/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate.strategy;

import java.lang.reflect.Method;
import java.util.Objects;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.validate.Context;
import org.aoju.bus.validate.annotation.InEnum;
import org.aoju.bus.validate.validators.Matcher;

public class InEnumStrategy
implements Matcher<Object, InEnum> {
    @Override
    public boolean on(Object object, InEnum annotation, Context context) {
        if (ObjectUtils.isEmpty(object)) {
            return false;
        }
        Class<? extends Enum> enumClass = annotation.enumClass();
        try {
            Enum[] enums;
            Method method = enumClass.getMethod(annotation.method(), new Class[0]);
            for (Enum e : enums = enumClass.getEnumConstants()) {
                Object value = ReflectUtils.invokeMethod(method, e);
                if (!Objects.equals(value, object)) continue;
                return true;
            }
            return false;
        }
        catch (NoSuchMethodException e) {
            throw new InstrumentException(e.getMessage());
        }
    }
}

