/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.TextUtils;

public class BeanPath {
    private static final char[] expChars = new char[]{'.', '[', ']'};
    protected List<String> patternParts;
    private boolean isStartWith$ = false;

    public BeanPath(String expression) {
        this.init(expression);
    }

    public static BeanPath create(String expression) {
        return new BeanPath(expression);
    }

    private static Object getFieldValue(Object bean, String expression) {
        if (StringUtils.isBlank(expression)) {
            return null;
        }
        if (StringUtils.contains(expression, ':')) {
            List<String> parts = StringUtils.splitTrim(expression, ':');
            int start = Integer.parseInt(parts.get(0));
            int end = Integer.parseInt(parts.get(1));
            int step = 1;
            if (3 == parts.size()) {
                step = Integer.parseInt(parts.get(2));
            }
            if (bean instanceof Collection) {
                return CollUtils.sub((Collection)bean, start, end, step);
            }
            if (ArrayUtils.isArray(bean)) {
                return ArrayUtils.sub(bean, start, end, step);
            }
        } else if (StringUtils.contains(expression, ',')) {
            List<String> keys = StringUtils.splitTrim(expression, ',');
            if (bean instanceof Collection) {
                return CollUtils.getAny((Collection)bean, Convert.convert(int[].class, keys));
            }
            if (ArrayUtils.isArray(bean)) {
                return ArrayUtils.getAny(bean, Convert.convert(int[].class, keys));
            }
            String[] unwrapedKeys = new String[keys.size()];
            for (int i = 0; i < unwrapedKeys.length; ++i) {
                unwrapedKeys[i] = StringUtils.unWrap(keys.get(i), '\'');
            }
            if (bean instanceof Map) {
                MapUtils.getAny((Map)bean, unwrapedKeys);
            } else {
                Map<String, Object> map = BeanUtils.beanToMap(bean);
                MapUtils.getAny(map, unwrapedKeys);
            }
        } else {
            return BeanUtils.getFieldValue(bean, expression);
        }
        return null;
    }

    private static String unWrapIfPossible(CharSequence expression) {
        if (StringUtils.containsAny(expression, " = ", " > ", " < ", " like ", ",")) {
            return expression.toString();
        }
        return StringUtils.unWrap(expression, '\'');
    }

    public Object get(Object bean) {
        return this.get(this.patternParts, bean, false);
    }

    public void set(Object bean, Object value) {
        this.set(bean, this.patternParts, value);
    }

    private void set(Object bean, List<String> patternParts, Object value) {
        Object subBean = this.get(patternParts, bean, true);
        if (null == subBean) {
            this.set(bean, patternParts.subList(0, patternParts.size() - 1), new HashMap());
            subBean = this.get(patternParts, bean, true);
        }
        BeanUtils.setFieldValue(subBean, patternParts.get(patternParts.size() - 1), value);
    }

    private Object get(List<String> patternParts, Object bean, boolean ignoreLast) {
        int length = patternParts.size();
        if (ignoreLast) {
            --length;
        }
        Object subBean = bean;
        boolean isFirst = true;
        for (int i = 0; i < length; ++i) {
            String patternPart = patternParts.get(i);
            if (null != (subBean = BeanPath.getFieldValue(subBean, patternPart))) continue;
            if (isFirst && !this.isStartWith$ && BeanUtils.isMatchName(bean, patternPart, true)) {
                subBean = bean;
                isFirst = false;
                continue;
            }
            return null;
        }
        return subBean;
    }

    private void init(String expression) {
        ArrayList<String> localPatternParts = new ArrayList<String>();
        int length = expression.length();
        TextUtils builder = new TextUtils();
        boolean isNumStart = false;
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if (0 == i && '$' == c) {
                this.isStartWith$ = true;
                continue;
            }
            if (ArrayUtils.contains(expChars, c)) {
                if (']' == c) {
                    if (!isNumStart) {
                        throw new IllegalArgumentException(StringUtils.format("Bad expression '{}':{}, we find ']' but no '[' !", expression, i));
                    }
                    isNumStart = false;
                    if (builder.length() > 0) {
                        localPatternParts.add(BeanPath.unWrapIfPossible(builder));
                    }
                    builder.reset();
                    continue;
                }
                if (isNumStart) {
                    throw new IllegalArgumentException(StringUtils.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, i));
                }
                if ('[' == c) {
                    isNumStart = true;
                }
                if (builder.length() > 0) {
                    localPatternParts.add(BeanPath.unWrapIfPossible(builder));
                }
                builder.reset();
                continue;
            }
            builder.append(c);
        }
        if (isNumStart) {
            throw new IllegalArgumentException(StringUtils.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, length - 1));
        }
        if (builder.length() > 0) {
            localPatternParts.add(BeanPath.unWrapIfPossible(builder));
        }
        this.patternParts = Collections.unmodifiableList(localPatternParts);
    }
}

