/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import java.nio.charset.Charset;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.utils.StringUtils;

public class Base64Encoder {
    public static byte[] encode(byte[] arr, boolean lineSep) {
        return Base64Encoder.encode(arr, lineSep, false);
    }

    public static byte[] encodeUrlSafe(byte[] arr, boolean lineSep) {
        return Base64Encoder.encode(arr, lineSep, true);
    }

    public static String encode(String source) {
        return Base64Encoder.encode(source, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static String encodeUrlSafe(String source) {
        return Base64Encoder.encodeUrlSafe(source, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static String encode(String source, String charset) {
        return Base64Encoder.encode(StringUtils.bytes((CharSequence)source, charset), charset);
    }

    public static String encodeUrlSafe(String source, String charset) {
        return Base64Encoder.encodeUrlSafe(StringUtils.bytes((CharSequence)source, charset), charset);
    }

    public static String encode(String source, Charset charset) {
        return Base64Encoder.encode(StringUtils.bytes((CharSequence)source, charset), charset);
    }

    public static String encodeUrlSafe(String source, Charset charset) {
        return Base64Encoder.encodeUrlSafe(StringUtils.bytes((CharSequence)source, charset), charset);
    }

    public static String encode(byte[] source) {
        return Base64Encoder.encode(source, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static String encodeUrlSafe(byte[] source) {
        return Base64Encoder.encodeUrlSafe(source, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static String encode(byte[] source, String charset) {
        return StringUtils.str(Base64Encoder.encode(source, false), charset);
    }

    public static String encodeUrlSafe(byte[] source, String charset) {
        return StringUtils.str(Base64Encoder.encodeUrlSafe(source, false), charset);
    }

    public static String encode(byte[] source, Charset charset) {
        return StringUtils.str(Base64Encoder.encode(source, false), charset);
    }

    public static String encodeUrlSafe(byte[] source, Charset charset) {
        return StringUtils.str(Base64Encoder.encodeUrlSafe(source, false), charset);
    }

    public static String encodeBuffer(byte[] buffer, boolean isUrlSafe, Charset charset) {
        return StringUtils.str(Base64Encoder.encode(buffer, true, isUrlSafe), charset);
    }

    public static String encodeBuffer(byte[] buffer, boolean isUrlSafe) {
        return Base64Encoder.encodeBuffer(buffer, isUrlSafe, org.aoju.bus.core.consts.Charset.UTF_8);
    }

    public static String encodeBuffer(byte[] buffer, Charset charset) {
        return Base64Encoder.encodeBuffer(buffer, false, charset);
    }

    public static String encodeBuffer(byte[] buffer) {
        return Base64Encoder.encodeBuffer(buffer, false);
    }

    public static byte[] encode(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        if (null == arr) {
            return null;
        }
        int len = arr.length;
        if (len == 0) {
            return new byte[0];
        }
        int evenlen = len / 3 * 3;
        int cnt = (len - 1) / 3 + 1 << 2;
        int destlen = cnt + (isMultiLine ? (cnt - 1) / 76 << 1 : 0);
        byte[] dest = new byte[destlen];
        byte[] encodeTable = isUrlSafe ? Base64.URL_SAFE_ENCODE_TABLE : Base64.STANDARD_ENCODE_TABLE;
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < evenlen) {
            int i = (arr[s++] & 0xFF) << 16 | (arr[s++] & 0xFF) << 8 | arr[s++] & 0xFF;
            dest[d++] = encodeTable[i >>> 18 & 0x3F];
            dest[d++] = encodeTable[i >>> 12 & 0x3F];
            dest[d++] = encodeTable[i >>> 6 & 0x3F];
            dest[d++] = encodeTable[i & 0x3F];
            if (!isMultiLine || ++cc != 19 || d >= destlen - 2) continue;
            dest[d++] = 13;
            dest[d++] = 10;
            cc = 0;
        }
        int left = len - evenlen;
        if (left > 0) {
            int i = (arr[evenlen] & 0xFF) << 10 | (left == 2 ? (arr[len - 1] & 0xFF) << 2 : 0);
            dest[destlen - 4] = encodeTable[i >> 12];
            dest[destlen - 3] = encodeTable[i >>> 6 & 0x3F];
            if (isUrlSafe) {
                int urlSafeLen = destlen - 2;
                if (2 == left) {
                    dest[destlen - 2] = encodeTable[i & 0x3F];
                    ++urlSafeLen;
                }
                byte[] urlSafeDest = new byte[urlSafeLen];
                System.arraycopy(dest, 0, urlSafeDest, 0, urlSafeLen);
                return urlSafeDest;
            }
            dest[destlen - 2] = left == 2 ? encodeTable[i & 0x3F] : 61;
            dest[destlen - 1] = 61;
        }
        return dest;
    }
}

