/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compare;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Comparator;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CompareUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class FieldCompare<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Field field;

    public FieldCompare(Class<T> beanClass, String fieldName) {
        this.field = ClassUtils.getDeclaredField(beanClass, fieldName);
        if (this.field == null) {
            throw new IllegalArgumentException(StringUtils.format("Field [{}] not found in Class [{}]", fieldName, beanClass.getName()));
        }
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable v2;
        Comparable v1;
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return 1;
        }
        if (null == o2) {
            return -1;
        }
        try {
            v1 = (Comparable)ReflectUtils.getFieldValue(o1, this.field);
            v2 = (Comparable)ReflectUtils.getFieldValue(o2, this.field);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return this.compare(o1, o2, v1, v2);
    }

    private int compare(T o1, T o2, Comparable fieldValue1, Comparable fieldValue2) {
        int result = ObjectUtils.compare(fieldValue1, fieldValue2);
        if (0 == result) {
            result = CompareUtils.compare(o1, o2, true);
        }
        return result;
    }
}

