/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import java.io.InputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.RandomUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Padding;

public class Symmetric {
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private boolean isZeroPadding;
    private Lock lock = new ReentrantLock();

    public Symmetric(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public Symmetric(String algorithm, byte[] key) {
        this(algorithm, Builder.generateKey(algorithm, key));
    }

    public Symmetric(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public Symmetric(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        if (null != paramsSpec) {
            this.setParams(paramsSpec);
        }
    }

    public Symmetric init(String algorithm, SecretKey key) {
        Assert.notBlank(algorithm, "'algorithm' must be not blank !", new Object[0]);
        this.secretKey = key;
        if (algorithm.startsWith("PBE")) {
            this.params = new PBEParameterSpec(RandomUtils.randomBytes(8), 100);
        }
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = StringUtils.replace(algorithm, Padding.ZeroPadding.name(), Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipher = Builder.createCipher(algorithm);
        return this;
    }

    public Symmetric setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.cipher.init(1, this.secretKey);
            } else {
                this.cipher.init(1, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.cipher.doFinal(this.paddingDataWithZero(data, this.cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String encryptHex(byte[] data) {
        return HexUtils.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(byte[] data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] encrypt(String data, String charset) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, charset));
    }

    public byte[] encrypt(String data, java.nio.charset.Charset charset) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, charset));
    }

    public String encryptHex(String data, String charset) {
        return HexUtils.encodeHexStr(this.encrypt(data, charset));
    }

    public String encryptHex(String data, java.nio.charset.Charset charset) {
        return HexUtils.encodeHexStr(this.encrypt(data, charset));
    }

    public String encryptBase64(String data, String charset) {
        return Base64.encode(this.encrypt(data, charset));
    }

    public String encryptBase64(String data, java.nio.charset.Charset charset) {
        return Base64.encode(this.encrypt(data, charset));
    }

    public byte[] encrypt(String data) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, Charset.UTF_8));
    }

    public String encryptHex(String data) {
        return HexUtils.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(String data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] encrypt(InputStream data) {
        return this.encrypt(IoUtils.readBytes(data));
    }

    public String encryptHex(InputStream data) {
        return HexUtils.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(InputStream data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        try {
            if (null == this.params) {
                this.cipher.init(2, this.secretKey);
            } else {
                this.cipher.init(2, (Key)this.secretKey, this.params);
            }
            blockSize = this.cipher.getBlockSize();
            decryptData = this.cipher.doFinal(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    public String decryptStr(byte[] bytes, java.nio.charset.Charset charset) {
        return StringUtils.str(this.decrypt(bytes), charset);
    }

    public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, Charset.UTF_8);
    }

    public byte[] decrypt(String data) {
        return this.decrypt(Builder.decode(data));
    }

    public String decryptStr(String data, java.nio.charset.Charset charset) {
        return StringUtils.str(this.decrypt(data), charset);
    }

    public String decryptStr(String data) {
        return this.decryptStr(data, Charset.UTF_8);
    }

    public byte[] decrypt(InputStream data) {
        return this.decrypt(IoUtils.readBytes(data));
    }

    public String decryptStr(InputStream data, java.nio.charset.Charset charset) {
        return StringUtils.str(this.decrypt(data), charset);
    }

    public String decryptStr(InputStream data) {
        return this.decryptStr(data, Charset.UTF_8);
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return ArrayUtils.resize(data, length + blockSize - remainLength);
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayUtils.resize(data, i + 1);
        }
        return data;
    }
}

