/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.forest.boot.jar;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.aoju.bus.forest.Builder;
import org.aoju.bus.forest.Complex;
import org.aoju.bus.forest.Injector;
import org.aoju.bus.forest.algorithm.Key;
import org.aoju.bus.forest.boot.jar.JarAllComplex;
import org.aoju.bus.forest.provider.EncryptorProvider;
import org.aoju.bus.forest.provider.EntryEncryptorProvider;
import org.aoju.bus.forest.streams.AlwaysInputStream;
import org.aoju.bus.forest.streams.AlwaysOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;

public class JarEncryptorProvider
extends EntryEncryptorProvider<JarArchiveEntry>
implements EncryptorProvider {
    private final int level;
    private final int mode;

    public JarEncryptorProvider(EncryptorProvider encryptorProvider) {
        this(encryptorProvider, new JarAllComplex());
    }

    public JarEncryptorProvider(EncryptorProvider encryptorProvider, Complex<JarArchiveEntry> filter) {
        this(encryptorProvider, 8, filter);
    }

    public JarEncryptorProvider(EncryptorProvider encryptorProvider, int level) {
        this(encryptorProvider, level, new JarAllComplex());
    }

    public JarEncryptorProvider(EncryptorProvider encryptorProvider, int level, Complex<JarArchiveEntry> filter) {
        this(encryptorProvider, level, Builder.MODE_NORMAL, filter);
    }

    public JarEncryptorProvider(EncryptorProvider encryptorProvider, int level, int mode) {
        this(encryptorProvider, level, mode, new JarAllComplex());
    }

    public JarEncryptorProvider(EncryptorProvider encryptorProvider, int level, int mode, Complex<JarArchiveEntry> filter) {
        super(encryptorProvider, filter);
        this.level = level;
        this.mode = mode;
    }

    @Override
    public void encrypt(Key key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.encrypt(key, fis, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(Key key, InputStream in, OutputStream out) throws IOException {
        JarArchiveInputStream zis = null;
        JarArchiveOutputStream zos = null;
        LinkedHashSet<String> indexes = new LinkedHashSet<String>();
        try {
            String mainClass;
            JarArchiveEntry entry;
            zis = new JarArchiveInputStream(in);
            zos = new JarArchiveOutputStream(out);
            zos.setLevel(this.level);
            AlwaysInputStream nis = new AlwaysInputStream((InputStream)zis);
            AlwaysOutputStream nos = new AlwaysOutputStream((OutputStream)zos);
            Manifest manifest = null;
            while ((entry = zis.getNextJarEntry()) != null) {
                JarArchiveEntry jarArchiveEntry;
                if (entry.getName().startsWith(Builder.XJAR_SRC_DIR) || entry.getName().endsWith("META-INF/") || entry.getName().endsWith("META-INF/FOREST.MF")) continue;
                if (entry.isDirectory()) {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                } else if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                    manifest = new Manifest(nis);
                    Attributes attributes = manifest.getMainAttributes();
                    String mainClass2 = attributes.getValue("Main-Class");
                    if (mainClass2 != null) {
                        attributes.putValue("Jar-Main-Class", mainClass2);
                        attributes.putValue("Main-Class", "org.aoju.bus.forest.archive.jar.BootJarLauncher");
                    }
                    if ((this.mode & Builder.FLAG_DANGER) == Builder.FLAG_DANGER) {
                        Builder.retainKey(key, attributes);
                    }
                    JarArchiveEntry jarArchiveEntry2 = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry2.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry2);
                    manifest.write(nos);
                } else {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    boolean filtered = this.on(entry);
                    if (filtered) {
                        indexes.add(entry.getName());
                    }
                    EncryptorProvider encryptor = filtered ? this.encryptorProvider : this.xNopEncryptor;
                    try (OutputStream eos = encryptor.encrypt(key, nos);){
                        Builder.transfer((InputStream)nis, eos);
                    }
                }
                zos.closeArchiveEntry();
            }
            if (!indexes.isEmpty()) {
                JarArchiveEntry xjarInfDir = new JarArchiveEntry("META-INF/");
                xjarInfDir.setTime(System.currentTimeMillis());
                zos.putArchiveEntry((ArchiveEntry)xjarInfDir);
                zos.closeArchiveEntry();
                JarArchiveEntry xjarInfIdx = new JarArchiveEntry("META-INF/FOREST.MF");
                xjarInfIdx.setTime(System.currentTimeMillis());
                zos.putArchiveEntry((ArchiveEntry)xjarInfIdx);
                for (String index : indexes) {
                    zos.write(index.getBytes());
                    zos.write(Builder.CRLF.getBytes());
                }
                zos.closeArchiveEntry();
            }
            String string = mainClass = manifest != null && manifest.getMainAttributes() != null ? manifest.getMainAttributes().getValue("Main-Class") : null;
            if (mainClass != null) {
                Injector.inject(zos);
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            Builder.close(zis);
            Builder.close(zos);
            throw throwable;
        }
        Builder.close((Closeable)zis);
        Builder.close((Closeable)zos);
    }
}

