/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.health.Builder;
import org.aoju.bus.logger.Logger;

public final class Config {
    private static final Properties configuration;

    private Config() {
    }

    public static String get(String key, String def) {
        return configuration.getProperty(key, def);
    }

    public static int get(String key, int def) {
        String value = configuration.getProperty(key);
        return value == null ? def : Builder.parseIntOrDefault(value, def);
    }

    public static double get(String key, double def) {
        String value = configuration.getProperty(key);
        return value == null ? def : Builder.parseDoubleOrDefault(value, def);
    }

    public static boolean get(String key, boolean def) {
        String value = configuration.getProperty(key);
        return value == null ? def : Boolean.parseBoolean(value);
    }

    public static void set(String key, Object val) {
        if (val == null) {
            configuration.remove(key);
        } else {
            configuration.setProperty(key, val.toString());
        }
    }

    public static void remove(String key) {
        configuration.remove(key);
    }

    public static void clear() {
        configuration.clear();
    }

    public static void load(Properties properties) {
        configuration.putAll((Map<?, ?>)properties);
    }

    static {
        block18: {
            configuration = new Properties();
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null && (loader = ClassLoader.getSystemClassLoader()) == null) {
                    throw new IOException();
                }
                ArrayList<URL> resources = Collections.list(loader.getResources("oshi.properties"));
                if (resources.isEmpty()) {
                    Logger.warn("No default configuration found", new Object[0]);
                    break block18;
                }
                if (resources.size() > 1) {
                    Logger.warn("Configuration conflict: there is more than one oshi.properties file on the classpath", new Object[0]);
                }
                try (InputStream in = ((URL)resources.get(0)).openStream();){
                    if (in != null) {
                        configuration.load(in);
                    }
                }
            }
            catch (IOException e) {
                Logger.warn("Failed to load default configuration", new Object[0]);
            }
        }
    }

    public static class PropertyException
    extends RuntimeException {
        private static final long serialVersionUID = -7482581936621748005L;

        public PropertyException(String property) {
            super("Invalid property: \"" + property + "\" = " + Config.get(property, null));
        }

        public PropertyException(String property, String message) {
            super("Invalid property \"" + property + "\": " + message);
        }
    }
}

