/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.common.windows;

import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.common.windows.PerfDataUtils;
import org.aoju.bus.logger.Logger;

public class PerfCounterHandler {
    private static PerfCounterHandler instance;
    private Map<PerfDataUtils.PerfCounter, WinNT.HANDLEByReference> counterHandleMap = new ConcurrentHashMap<PerfDataUtils.PerfCounter, WinNT.HANDLEByReference>();
    private Map<String, WinNT.HANDLEByReference> queryHandleMap = new ConcurrentHashMap<String, WinNT.HANDLEByReference>();
    private Map<String, List<PerfDataUtils.PerfCounter>> queryCounterMap = new ConcurrentHashMap<String, List<PerfDataUtils.PerfCounter>>();

    private PerfCounterHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PerfCounterHandler.this.removeAllCounters();
            }
        });
    }

    public static synchronized PerfCounterHandler getInstance() {
        if (instance == null) {
            instance = new PerfCounterHandler();
        }
        return instance;
    }

    public boolean addCounterToQuery(PerfDataUtils.PerfCounter counter) {
        return this.addCounterToQuery(counter, counter.getObject());
    }

    public boolean addCounterToQuery(PerfDataUtils.PerfCounter counter, String key) {
        WinNT.HANDLEByReference q = this.getOrOpenQuery(key);
        if (q == null) {
            Logger.error("Failed to open a query for PDH object: {}", counter.getObject());
            return false;
        }
        WinNT.HANDLEByReference p = new WinNT.HANDLEByReference();
        if (PerfDataUtils.addCounter(q, counter.getCounterPath(), p)) {
            this.counterHandleMap.put(counter, p);
            List<PerfDataUtils.PerfCounter> counterList = this.queryCounterMap.get(key);
            if (counterList != null) {
                counterList.add(counter);
            }
            return true;
        }
        return false;
    }

    public boolean removeCounterFromQuery(PerfDataUtils.PerfCounter counter) {
        return this.removeCounterFromQuery(counter, counter.getObject());
    }

    public boolean removeCounterFromQuery(PerfDataUtils.PerfCounter counter, String key) {
        List<PerfDataUtils.PerfCounter> counterList;
        WinNT.HANDLEByReference href = this.counterHandleMap.remove(counter);
        boolean success = false;
        if (href != null) {
            success = PerfDataUtils.removeCounter(href);
        }
        if ((counterList = this.queryCounterMap.get(key)) != null && counterList.remove(counter) && counterList.isEmpty()) {
            this.queryCounterMap.remove(key);
            PerfDataUtils.closeQuery(this.queryHandleMap.remove(key));
        }
        return success;
    }

    public void removeAllCountersFromQuery(String queryKey) {
        List<PerfDataUtils.PerfCounter> counterList = this.queryCounterMap.remove(queryKey);
        if (counterList == null) {
            return;
        }
        for (PerfDataUtils.PerfCounter counter : counterList) {
            WinNT.HANDLEByReference href = this.counterHandleMap.remove(counter);
            if (href == null) continue;
            PerfDataUtils.removeCounter(href);
        }
        WinNT.HANDLEByReference href = this.queryHandleMap.remove(queryKey);
        if (href != null) {
            PerfDataUtils.closeQuery(href);
        }
    }

    public void removeAllCounters() {
        for (WinNT.HANDLEByReference href : this.counterHandleMap.values()) {
            PerfDataUtils.removeCounter(href);
        }
        this.counterHandleMap.clear();
        for (WinNT.HANDLEByReference query : this.queryHandleMap.values()) {
            PerfDataUtils.closeQuery(query);
        }
        this.queryHandleMap.clear();
        this.queryCounterMap.clear();
    }

    public long updateQuery(String key) {
        if (!this.queryHandleMap.containsKey(key)) {
            Logger.error("Query key {} does not exist to update.", key);
            return 0L;
        }
        return PerfDataUtils.updateQueryTimestamp(this.queryHandleMap.get(key));
    }

    public long queryCounter(PerfDataUtils.PerfCounter counter) {
        if (!this.counterHandleMap.containsKey(counter)) {
            Logger.error("Counter {} does not exist to query.", counter.getCounterPath());
            return 0L;
        }
        long value = PerfDataUtils.queryCounter(this.counterHandleMap.get(counter));
        if (value < 0L) {
            Logger.warn("Error querying counter {}: {}", counter.getCounterPath(), String.format(Builder.formatError((int)value), new Object[0]));
            return 0L;
        }
        return value;
    }

    private WinNT.HANDLEByReference getOrOpenQuery(String key) {
        if (this.queryHandleMap.containsKey(key)) {
            return this.queryHandleMap.get(key);
        }
        WinNT.HANDLEByReference q = new WinNT.HANDLEByReference();
        if (PerfDataUtils.openQuery(q)) {
            this.queryHandleMap.put(key, q);
            List counterList = Collections.synchronizedList(new ArrayList());
            this.queryCounterMap.put(key, counterList);
            return q;
        }
        return null;
    }
}

