/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.common.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.EnumMap;
import java.util.Map;
import org.aoju.bus.health.common.windows.PerfCounterHandler;
import org.aoju.bus.health.common.windows.PerfDataUtils;
import org.aoju.bus.health.common.windows.WmiQueryHandler;
import org.aoju.bus.health.common.windows.WmiUtils;
import org.aoju.bus.logger.Logger;

public class PerfCounterQuery<T extends Enum<T>> {
    public static final String TOTAL_INSTANCE = "_Total";
    public static final String TOTAL_INSTANCES = "*_Total";
    public static final String NOT_TOTAL_INSTANCE = "^_Total";
    public static final String NOT_TOTAL_INSTANCES = "^*_Total";
    protected final Class<T> propertyEnum;
    protected final String perfObject;
    protected final String perfWmiClass;
    protected final String queryKey;
    protected CounterDataSource source;
    protected PerfCounterHandler pdhQueryHandler;
    protected WmiQueryHandler wmiQueryHandler;
    protected WbemcliUtil.WmiQuery<T> counterQuery = null;
    private EnumMap<T, PerfDataUtils.PerfCounter> counterMap = null;

    public PerfCounterQuery(Class<T> propertyEnum, String perfObject, String perfWmiClass) {
        this(propertyEnum, perfObject, perfWmiClass, perfObject);
    }

    public PerfCounterQuery(Class<T> propertyEnum, String perfObject, String perfWmiClass, String queryKey) {
        this.propertyEnum = propertyEnum;
        this.perfObject = perfObject;
        this.perfWmiClass = perfWmiClass;
        this.queryKey = queryKey;
        this.pdhQueryHandler = PerfCounterHandler.getInstance();
        this.wmiQueryHandler = WmiQueryHandler.createInstance();
        this.source = CounterDataSource.PDH;
    }

    public boolean setDataSource(CounterDataSource source) {
        this.source = source;
        switch (source) {
            case PDH: {
                Logger.debug("Attempting to set PDH Data Source.", new Object[0]);
                this.unInitWmiCounters();
                return this.initPdhCounters();
            }
            case WMI: {
                Logger.debug("Attempting to set WMI Data Source.", new Object[0]);
                this.unInitPdhCounters();
                this.initWmiCounters();
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid Data Source specified.");
    }

    protected boolean initPdhCounters() {
        this.counterMap = new EnumMap(this.propertyEnum);
        for (Enum prop : (Enum[])this.propertyEnum.getEnumConstants()) {
            PerfDataUtils.PerfCounter counter = PerfDataUtils.createCounter(this.perfObject, ((PdhCounterProperty)((Object)prop)).getInstance(), ((PdhCounterProperty)((Object)prop)).getCounter());
            this.counterMap.put(prop, counter);
            if (this.pdhQueryHandler.addCounterToQuery(counter, this.queryKey)) continue;
            this.unInitPdhCounters();
            return false;
        }
        return true;
    }

    protected void unInitPdhCounters() {
        this.pdhQueryHandler.removeAllCountersFromQuery(this.queryKey);
        this.counterMap = null;
    }

    protected void initWmiCounters() {
        this.counterQuery = new WbemcliUtil.WmiQuery(this.perfWmiClass, this.propertyEnum);
    }

    protected void unInitWmiCounters() {
        this.counterQuery = null;
    }

    public Map<T, Long> queryValues() {
        EnumMap valueMap = new EnumMap(this.propertyEnum);
        Enum[] props = (Enum[])this.propertyEnum.getEnumConstants();
        if (this.source.equals((Object)CounterDataSource.PDH)) {
            if (this.initPdhCounters() && this.queryPdh(valueMap, props)) {
                this.unInitPdhCounters();
            } else {
                this.setDataSource(CounterDataSource.WMI);
            }
        }
        if (this.source.equals((Object)CounterDataSource.WMI)) {
            this.queryWmi(valueMap, props);
        }
        return valueMap;
    }

    private boolean queryPdh(Map<T, Long> valueMap, T[] props) {
        if (this.counterMap != null && 0L < this.pdhQueryHandler.updateQuery(this.queryKey)) {
            for (T prop : props) {
                valueMap.put(prop, this.pdhQueryHandler.queryCounter(this.counterMap.get(prop)));
            }
            return true;
        }
        return false;
    }

    private void queryWmi(Map<T, Long> valueMap, T[] props) {
        WbemcliUtil.WmiResult<T> result = this.wmiQueryHandler.queryWMI(this.counterQuery);
        if (result.getResultCount() > 0) {
            block5: for (T prop : props) {
                switch (result.getCIMType(prop)) {
                    case 18: {
                        valueMap.put(prop, Long.valueOf(WmiUtils.getUint16(result, prop, 0)));
                        continue block5;
                    }
                    case 19: {
                        valueMap.put(prop, WmiUtils.getUint32asLong(result, prop, 0));
                        continue block5;
                    }
                    case 21: {
                        valueMap.put(prop, WmiUtils.getUint64(result, prop, 0));
                        continue block5;
                    }
                    default: {
                        throw new ClassCastException("Unimplemented CIM Type Mapping.");
                    }
                }
            }
        }
    }

    public static interface PdhCounterProperty {
        public String getInstance();

        public String getCounter();
    }

    public static enum CounterDataSource {
        PDH,
        WMI;

    }
}

