/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.aoju.bus.health.hardware.NetworkIF;
import org.aoju.bus.health.hardware.Networks;
import org.aoju.bus.logger.Logger;

public abstract class AbstractNetworks
implements Networks {
    @Override
    public NetworkIF[] getNetworks() {
        Enumeration<NetworkInterface> interfaces;
        ArrayList<NetworkIF> result = new ArrayList<NetworkIF>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            Logger.error("Socket exception when retrieving interfaces: {}", ex);
            return new NetworkIF[0];
        }
        for (NetworkInterface netint : Collections.list(interfaces)) {
            try {
                if (netint.isLoopback() || netint.getHardwareAddress() == null) continue;
                NetworkIF netIF = new NetworkIF();
                netIF.setNetworkInterface(netint);
                netIF.updateAttributes();
                result.add(netIF);
            }
            catch (SocketException ex) {
                Logger.error("Socket exception when retrieving interface \"{}\": {}", netint.getName(), ex);
            }
        }
        return result.toArray(new NetworkIF[0]);
    }
}

