/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware;

import org.aoju.bus.health.Builder;

public class HWPartition
implements Comparable<HWPartition> {
    private String identification;
    private String name;
    private String type;
    private String uuid;
    private long size;
    private int major;
    private int minor;
    private String mountPoint;

    public HWPartition(String identification, String name, String type, String uuid, long size, int major, int minor, String mountPoint) {
        this.setIdentification(identification);
        this.setName(name);
        this.setType(type);
        this.setUuid(uuid);
        this.setSize(size);
        this.setMajor(major);
        this.setMinor(minor);
        this.setMountPoint(mountPoint);
    }

    public HWPartition() {
        this("", "", "", "", 0L, 0, 0, "");
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification == null ? "" : identification;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type == null ? "" : type;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid == null ? "" : uuid;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint == null ? "" : mountPoint;
    }

    @Override
    public int compareTo(HWPartition part) {
        return this.getIdentification().compareTo(part.getIdentification());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identification == null ? 0 : this.identification.hashCode());
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + (this.mountPoint == null ? 0 : this.mountPoint.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        HWPartition other = (HWPartition)obj;
        if (this.identification == null ? other.identification != null : !this.identification.equals(other.identification)) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.mountPoint == null ? other.mountPoint != null : !this.mountPoint.equals(other.mountPoint)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIdentification()).append(": ");
        sb.append(this.getName()).append(" ");
        sb.append("(").append(this.getType()).append(") ");
        sb.append("Maj:Min=").append(this.getMajor()).append(":").append(this.getMinor()).append(", ");
        sb.append("size: ").append(Builder.formatBytesDecimal(this.getSize()));
        sb.append(this.getMountPoint().isEmpty() ? "" : " @ " + this.getMountPoint());
        return sb.toString();
    }
}

