/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.linux;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.common.linux.ProcUtils;
import org.aoju.bus.health.hardware.AbstractBaseboard;

final class LinuxBaseboard
extends AbstractBaseboard {
    private final Supplier<String> manufacturer = Memoizer.memoize(this::queryManufacturer);
    private final Supplier<String> model = Memoizer.memoize(this::queryModel);
    private final Supplier<String> version = Memoizer.memoize(this::queryVersion);
    private final Supplier<String> serialNumber = Memoizer.memoize(this::querySerialNumber);

    LinuxBaseboard() {
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getModel() {
        return this.model.get();
    }

    @Override
    public String getVersion() {
        return this.version.get();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    private String queryManufacturer() {
        String result = null;
        result = this.queryManufacturerFromSysfs();
        if (result == null && (result = this.queryProcCpu().manufacturer) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryModel() {
        String result = null;
        result = this.queryModelFromSysfs();
        if (result == null && (result = this.queryProcCpu().model) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryVersion() {
        String result = null;
        result = this.queryVersionFromSysfs();
        if (result == null && (result = this.queryProcCpu().version) == null) {
            return "unknown";
        }
        return result;
    }

    private String querySerialNumber() {
        String result = null;
        result = this.querySerialFromSysfs();
        if (result == null && (result = this.queryProcCpu().serialNumber) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryManufacturerFromSysfs() {
        String boardVendor = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_vendor").trim();
        if (!boardVendor.isEmpty()) {
            return boardVendor;
        }
        return null;
    }

    private String queryModelFromSysfs() {
        String boardName = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_name").trim();
        if (!boardName.isEmpty()) {
            return boardName;
        }
        return null;
    }

    private String queryVersionFromSysfs() {
        String boardVersion = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_version").trim();
        if (!boardVersion.isEmpty()) {
            return boardVersion;
        }
        return null;
    }

    private String querySerialFromSysfs() {
        String boardSerial = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial").trim();
        if (!boardSerial.isEmpty()) {
            return boardSerial;
        }
        return null;
    }

    private ProcCpuStrings queryProcCpu() {
        String pcManufacturer = null;
        String pcModel = null;
        String pcVersion = null;
        String pcSerialNumber = null;
        List<String> cpuInfo = Builder.readFile(ProcUtils.getProcPath() + "/cpuinfo");
        for (String line : cpuInfo) {
            String[] splitLine = Builder.whitespacesColonWhitespace.split(line);
            if (splitLine.length < 2) continue;
            switch (splitLine[0]) {
                case "Hardware": {
                    pcModel = splitLine[1];
                    break;
                }
                case "Revision": {
                    pcVersion = splitLine[1];
                    if (pcVersion.length() <= 1) break;
                    pcManufacturer = this.queryBoardManufacturer(pcVersion.charAt(1));
                    break;
                }
                case "Serial": {
                    pcSerialNumber = splitLine[1];
                    break;
                }
            }
        }
        return new ProcCpuStrings(pcManufacturer, pcModel, pcVersion, pcSerialNumber);
    }

    private String queryBoardManufacturer(char digit) {
        switch (digit) {
            case '0': {
                return "Sony UK";
            }
            case '1': {
                return "Egoman";
            }
            case '2': {
                return "Embest";
            }
            case '3': {
                return "Sony Japan";
            }
            case '4': {
                return "Embest";
            }
            case '5': {
                return "Stadium";
            }
        }
        return "unknown";
    }

    private static final class ProcCpuStrings {
        private final String manufacturer;
        private final String model;
        private final String version;
        private final String serialNumber;

        private ProcCpuStrings(String manufacturer, String model, String version, String serialNumber) {
            this.manufacturer = StringUtils.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = StringUtils.isBlank(model) ? "unknown" : model;
            this.version = StringUtils.isBlank(version) ? "unknown" : version;
            this.serialNumber = StringUtils.isBlank(serialNumber) ? "unknown" : serialNumber;
        }
    }
}

