/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.linux;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.common.linux.ProcUtils;
import org.aoju.bus.health.hardware.AbstractComputerSystem;
import org.aoju.bus.health.hardware.Baseboard;
import org.aoju.bus.health.hardware.Firmware;
import org.aoju.bus.health.hardware.linux.LinuxBaseboard;
import org.aoju.bus.health.hardware.linux.LinuxFirmware;

final class LinuxComputerSystem
extends AbstractComputerSystem {
    private final Supplier<String> manufacturer = Memoizer.memoize(this::queryManufacturer);
    private final Supplier<String> model = Memoizer.memoize(this::queryModel);
    private final Supplier<String> serialNumber = Memoizer.memoize(this::querySerialNumber);

    LinuxComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getModel() {
        return this.model.get();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    @Override
    public Firmware createFirmware() {
        return new LinuxFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new LinuxBaseboard();
    }

    private String queryManufacturer() {
        String result = null;
        result = this.queryManufacturerFromSysfs();
        if (result == null && (result = this.queryManufacturerFromProcCpu()) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryModel() {
        String result = null;
        result = this.queryModelFromSysfs();
        if (result == null && (result = this.queryModelFromDeviceTree()) == null && (result = this.queryModelFromLshw()) == null) {
            return "unknown";
        }
        return result;
    }

    private String querySerialNumber() {
        String result = null;
        result = this.querySerialFromSysfs();
        if (result == null && (result = this.querySerialFromDmiDecode()) == null && (result = this.querySerialFromLshal()) == null && (result = this.querySerialFromLshw()) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryManufacturerFromSysfs() {
        String sysVendor = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/sys_vendor").trim();
        if (!sysVendor.isEmpty()) {
            return sysVendor;
        }
        return null;
    }

    private String queryManufacturerFromProcCpu() {
        List<String> cpuInfo = Builder.readFile(ProcUtils.getProcPath() + "/cpuinfo");
        for (String line : cpuInfo) {
            if (!line.startsWith("CPU implementer")) continue;
            int part = Builder.parseLastInt(line, 0);
            switch (part) {
                case 65: {
                    return "ARM";
                }
                case 66: {
                    return "Broadcom";
                }
                case 67: {
                    return "Cavium";
                }
                case 68: {
                    return "DEC";
                }
                case 78: {
                    return "Nvidia";
                }
                case 80: {
                    return "APM";
                }
                case 81: {
                    return "Qualcomm";
                }
                case 83: {
                    return "Samsung";
                }
                case 86: {
                    return "Marvell";
                }
                case 102: {
                    return "Faraday";
                }
                case 105: {
                    return "Intel";
                }
            }
            return null;
        }
        return null;
    }

    private String queryModelFromSysfs() {
        String productName = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/product_name").trim();
        String productVersion = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/product_version").trim();
        if (productName.isEmpty()) {
            if (!productVersion.isEmpty()) {
                return productVersion;
            }
        } else {
            if (!productVersion.isEmpty() && !"None".equals(productVersion)) {
                return productName + " (version: " + productVersion + ")";
            }
            return productName;
        }
        return null;
    }

    private String queryModelFromDeviceTree() {
        String modelStr = Builder.getStringFromFile("/sys/firmware/devicetree/base/model");
        if (!modelStr.isEmpty()) {
            return modelStr.replace("Machine: ", "");
        }
        return null;
    }

    private String queryModelFromLshw() {
        String modelMarker = "product:";
        for (String checkLine : Command.runNative("lshw -C system")) {
            if (!checkLine.contains(modelMarker)) continue;
            return checkLine.split(modelMarker)[1].trim();
        }
        return null;
    }

    private String querySerialFromSysfs() {
        String serial = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/product_serial");
        if (serial.isEmpty() || "None".equals(serial)) {
            serial = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial");
            if (serial.isEmpty() || "None".equals(serial)) {
                return null;
            }
            return serial;
        }
        return null;
    }

    private String querySerialFromDmiDecode() {
        String marker = "Serial Number:";
        for (String checkLine : Command.runNative("dmidecode -t system")) {
            if (!checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        return null;
    }

    private String querySerialFromLshal() {
        String marker = "system.hardware.serial =";
        for (String checkLine : Command.runNative("lshal")) {
            if (!checkLine.contains(marker)) continue;
            return Builder.getSingleQuoteStringValue(checkLine);
        }
        return null;
    }

    private String querySerialFromLshw() {
        String serialMarker = "serial:";
        for (String checkLine : Command.runNative("lshw -C system")) {
            if (!checkLine.contains(serialMarker)) continue;
            return checkLine.split(serialMarker)[1].trim();
        }
        return null;
    }
}

