/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.linux;

import org.aoju.bus.health.Builder;
import org.aoju.bus.health.hardware.AbstractNetworks;
import org.aoju.bus.health.hardware.NetworkIF;

public class LinuxNetworks
extends AbstractNetworks {
    public static void updateNetworkStats(NetworkIF netIF) {
        String txBytesPath = String.format("/sys/class/net/%s/statistics/tx_bytes", netIF.getName());
        String rxBytesPath = String.format("/sys/class/net/%s/statistics/rx_bytes", netIF.getName());
        String txPacketsPath = String.format("/sys/class/net/%s/statistics/tx_packets", netIF.getName());
        String rxPacketsPath = String.format("/sys/class/net/%s/statistics/rx_packets", netIF.getName());
        String txErrorsPath = String.format("/sys/class/net/%s/statistics/tx_errors", netIF.getName());
        String rxErrorsPath = String.format("/sys/class/net/%s/statistics/rx_errors", netIF.getName());
        String speed = String.format("/sys/class/net/%s/speed", netIF.getName());
        netIF.setTimeStamp(System.currentTimeMillis());
        netIF.setBytesSent(Builder.getUnsignedLongFromFile(txBytesPath));
        netIF.setBytesRecv(Builder.getUnsignedLongFromFile(rxBytesPath));
        netIF.setPacketsSent(Builder.getUnsignedLongFromFile(txPacketsPath));
        netIF.setPacketsRecv(Builder.getUnsignedLongFromFile(rxPacketsPath));
        netIF.setOutErrors(Builder.getUnsignedLongFromFile(txErrorsPath));
        netIF.setInErrors(Builder.getUnsignedLongFromFile(rxErrorsPath));
        long netSpeed = Builder.getUnsignedLongFromFile(speed) * 1024L * 1024L;
        netIF.setSpeed(netSpeed < 0L ? 0L : netSpeed);
    }
}

