/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.mac;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.common.mac.SysctlUtils;
import org.aoju.bus.health.hardware.AbstractCentralProcessor;
import org.aoju.bus.health.hardware.CentralProcessor;
import org.aoju.bus.logger.Logger;

public class MacCentralProcessor
extends AbstractCentralProcessor {
    @Override
    protected final CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String cpuVendor = SysctlUtils.sysctl("machdep.cpu.vendor", "");
        String cpuName = SysctlUtils.sysctl("machdep.cpu.brand_string", "");
        int i = SysctlUtils.sysctl("machdep.cpu.stepping", -1);
        String cpuStepping = i < 0 ? "" : Integer.toString(i);
        i = SysctlUtils.sysctl("machdep.cpu.model", -1);
        String cpuModel = i < 0 ? "" : Integer.toString(i);
        i = SysctlUtils.sysctl("machdep.cpu.family", -1);
        String cpuFamily = i < 0 ? "" : Integer.toString(i);
        long processorIdBits = 0L;
        processorIdBits |= (long)SysctlUtils.sysctl("machdep.cpu.signature", 0);
        String processorID = String.format("%016X", processorIdBits |= (SysctlUtils.sysctl("machdep.cpu.feature_bits", 0L) & 0xFFFFFFFFFFFFFFFFL) << 32);
        boolean cpu64bit = SysctlUtils.sysctl("hw.cpu64bit_capable", 0) != 0;
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, processorID, cpu64bit);
    }

    @Override
    protected CentralProcessor.LogicalProcessor[] initProcessorCounts() {
        int logicalProcessorCount = SysctlUtils.sysctl("hw.logicalcpu", 1);
        int physicalProcessorCount = SysctlUtils.sysctl("hw.physicalcpu", 1);
        int physicalPackageCount = SysctlUtils.sysctl("hw.packages", 1);
        CentralProcessor.LogicalProcessor[] logProcs = new CentralProcessor.LogicalProcessor[logicalProcessorCount];
        for (int i = 0; i < logProcs.length; ++i) {
            logProcs[i] = new CentralProcessor.LogicalProcessor(i, i * physicalProcessorCount / logicalProcessorCount, i * physicalPackageCount / logicalProcessorCount);
        }
        return logProcs;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        SystemB.HostCpuLoadInfo cpuLoadInfo;
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_statistics(machPort, 3, (Structure)(cpuLoadInfo = new SystemB.HostCpuLoadInfo()), new IntByReference(cpuLoadInfo.size()))) {
            Logger.error("Failed to get System CPU ticks. Error code: {} ", Native.getLastError());
            return ticks;
        }
        ticks[CentralProcessor.TickType.USER.getIndex()] = cpuLoadInfo.cpu_ticks[0];
        ticks[CentralProcessor.TickType.NICE.getIndex()] = cpuLoadInfo.cpu_ticks[3];
        ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = cpuLoadInfo.cpu_ticks[1];
        ticks[CentralProcessor.TickType.IDLE.getIndex()] = cpuLoadInfo.cpu_ticks[2];
        return ticks;
    }

    @Override
    public long[] queryCurrentFreq() {
        long[] freqs = new long[this.getLogicalProcessorCount()];
        Arrays.fill(freqs, SysctlUtils.sysctl("hw.cpufrequency", -1L));
        return freqs;
    }

    @Override
    public long queryMaxFreq() {
        return SysctlUtils.sysctl("hw.cpufrequency_max", -1L);
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = SystemB.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            Arrays.fill(average, -1.0);
        }
        return average;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        IntByReference procInfoCount;
        PointerByReference procCpuLoadInfo;
        IntByReference procCount;
        long[][] ticks = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_processor_info(machPort, 2, procCount = new IntByReference(), procCpuLoadInfo = new PointerByReference(), procInfoCount = new IntByReference())) {
            Logger.error("Failed to update CPU Load. Error code: {}", Native.getLastError());
            return ticks;
        }
        int[] cpuTicks = procCpuLoadInfo.getValue().getIntArray(0L, procInfoCount.getValue());
        for (int cpu = 0; cpu < procCount.getValue(); ++cpu) {
            int offset = cpu * 4;
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = Builder.getUnsignedInt(cpuTicks[offset + 0]);
            ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] = Builder.getUnsignedInt(cpuTicks[offset + 3]);
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = Builder.getUnsignedInt(cpuTicks[offset + 1]);
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = Builder.getUnsignedInt(cpuTicks[offset + 2]);
        }
        return ticks;
    }

    @Override
    public long queryContextSwitches() {
        SystemB.VMMeter vmstats;
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_statistics(machPort, 2, (Structure)(vmstats = new SystemB.VMMeter()), new IntByReference(vmstats.size()))) {
            Logger.error("Failed to update vmstats. Error code: {}", Native.getLastError());
            return -1L;
        }
        return Builder.unsignedIntToLong(vmstats.v_swtch);
    }

    @Override
    public long queryInterrupts() {
        SystemB.VMMeter vmstats;
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_statistics(machPort, 2, (Structure)(vmstats = new SystemB.VMMeter()), new IntByReference(vmstats.size()))) {
            Logger.error("Failed to update vmstats. Error code: {}", Native.getLastError());
            return -1L;
        }
        return Builder.unsignedIntToLong(vmstats.v_intr);
    }
}

