/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.freebsd;

import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.hardware.AbstractNetworks;
import org.aoju.bus.health.hardware.NetworkIF;

public class FreeBsdNetworks
extends AbstractNetworks {
    public static void updateNetworkStats(NetworkIF netIF) {
        String stats = Command.getAnswerAt("netstat -bI " + netIF.getName(), 1);
        netIF.setTimeStamp(System.currentTimeMillis());
        String[] split = Builder.whitespaces.split(stats);
        if (split.length < 12) {
            return;
        }
        netIF.setBytesSent(Builder.parseUnsignedLongOrDefault(split[10], 0L));
        netIF.setBytesRecv(Builder.parseUnsignedLongOrDefault(split[7], 0L));
        netIF.setPacketsSent(Builder.parseUnsignedLongOrDefault(split[8], 0L));
        netIF.setPacketsRecv(Builder.parseUnsignedLongOrDefault(split[4], 0L));
        netIF.setOutErrors(Builder.parseUnsignedLongOrDefault(split[9], 0L));
        netIF.setInErrors(Builder.parseUnsignedLongOrDefault(split[5], 0L));
    }
}

