/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.function.Supplier;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.common.unix.solaris.KstatUtils;
import org.aoju.bus.health.hardware.AbstractGlobalMemory;
import org.aoju.bus.health.hardware.VirtualMemory;
import org.aoju.bus.health.hardware.unix.solaris.SolarisVirtualMemory;

public class SolarisGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Long> pageSize = Memoizer.memoize(this::queryPageSize);
    private final Supplier<SystemPages> systemPages = Memoizer.memoize(this::readSystemPages, Memoizer.defaultExpiration());
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    @Override
    public long getAvailable() {
        return this.systemPages.get().available;
    }

    @Override
    public long getTotal() {
        return this.systemPages.get().total;
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private long queryPageSize() {
        return Builder.parseLongOrDefault(Command.getFirstAnswer("pagesize"), 4096L);
    }

    private VirtualMemory createVirtualMemory() {
        return new SolarisVirtualMemory();
    }

    private SystemPages readSystemPages() {
        long memAvailable = 0L;
        long memTotal = 0L;
        try (KstatUtils.KstatChain kc = KstatUtils.openChain();){
            LibKstat.Kstat ksp = kc.lookup(null, -1, "system_pages");
            if (ksp != null && kc.read(ksp)) {
                memAvailable = KstatUtils.dataLookupLong(ksp, "availrmem") * this.getPageSize();
                memTotal = KstatUtils.dataLookupLong(ksp, "physmem") * this.getPageSize();
            }
        }
        return new SystemPages(memTotal, memAvailable);
    }

    private static final class SystemPages {
        private final long total;
        private final long available;

        private SystemPages(long total, long available) {
            this.total = total;
            this.available = available;
        }
    }
}

