/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import org.aoju.bus.health.common.unix.solaris.KstatUtils;
import org.aoju.bus.health.hardware.AbstractNetworks;
import org.aoju.bus.health.hardware.NetworkIF;

public class SolarisNetworks
extends AbstractNetworks {
    public static void updateNetworkStats(NetworkIF netIF) {
        try (KstatUtils.KstatChain kc = KstatUtils.openChain();){
            LibKstat.Kstat ksp = kc.lookup("link", -1, netIF.getName());
            if (ksp == null) {
                ksp = kc.lookup(null, -1, netIF.getName());
            }
            if (ksp != null && kc.read(ksp)) {
                netIF.setBytesSent(KstatUtils.dataLookupLong(ksp, "obytes64"));
                netIF.setBytesRecv(KstatUtils.dataLookupLong(ksp, "rbytes64"));
                netIF.setPacketsSent(KstatUtils.dataLookupLong(ksp, "opackets64"));
                netIF.setPacketsRecv(KstatUtils.dataLookupLong(ksp, "ipackets64"));
                netIF.setOutErrors(KstatUtils.dataLookupLong(ksp, "oerrors"));
                netIF.setInErrors(KstatUtils.dataLookupLong(ksp, "ierrors"));
                netIF.setSpeed(KstatUtils.dataLookupLong(ksp, "ifspeed"));
                netIF.setTimeStamp(ksp.ks_snaptime / 1000000L);
            }
        }
    }
}

