/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.List;
import java.util.Map;
import org.aoju.bus.health.common.windows.PerfWildcardQuery;
import org.aoju.bus.health.common.windows.WmiQueryHandler;
import org.aoju.bus.health.common.windows.WmiUtils;
import org.aoju.bus.health.hardware.AbstractSensors;
import org.aoju.bus.logger.Logger;

public class WindowsSensors
extends AbstractSensors {
    private static final String BASE_SENSOR_CLASS = "Sensor";
    private final WbemcliUtil.WmiQuery<OhmHardwareProperty> ohmHardwareQuery = new WbemcliUtil.WmiQuery("ROOT\\OpenHardwareMonitor", "Hardware WHERE HardwareType=\"CPU\"", OhmHardwareProperty.class);
    private final WbemcliUtil.WmiQuery<OhmHardwareProperty> owhVoltageQuery = new WbemcliUtil.WmiQuery("ROOT\\OpenHardwareMonitor", "Hardware WHERE SensorType=\"Voltage\"", OhmHardwareProperty.class);
    private final WbemcliUtil.WmiQuery<OhmSensorProperty> ohmSensorQuery = new WbemcliUtil.WmiQuery("ROOT\\OpenHardwareMonitor", null, OhmSensorProperty.class);
    private final WbemcliUtil.WmiQuery<FanProperty> fanQuery = new WbemcliUtil.WmiQuery("Win32_Fan", FanProperty.class);
    private final WbemcliUtil.WmiQuery<VoltProperty> voltQuery = new WbemcliUtil.WmiQuery("Win32_Processor", VoltProperty.class);
    private final PerfWildcardQuery<ThermalZoneProperty> thermalZonePerfCounters = new PerfWildcardQuery<ThermalZoneProperty>(ThermalZoneProperty.class, "Thermal Zone Information", "Win32_PerfRawData_Counters_ThermalZoneInformation WHERE Name LIKE \"%cpu%\"");
    private final WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();

    @Override
    public double queryCpuTemperature() {
        double tempC = this.getTempFromOHM();
        if (tempC > 0.0) {
            return tempC;
        }
        tempC = this.getTempFromPerfCounters();
        return tempC;
    }

    private double getTempFromOHM() {
        WbemcliUtil.WmiResult<OhmHardwareProperty> ohmHardware = this.wmiQueryHandler.queryWMI(this.ohmHardwareQuery);
        if (ohmHardware.getResultCount() > 0) {
            Logger.debug("Found Temperature data in Open Hardware Monitor", new Object[0]);
            String cpuIdentifier = WmiUtils.getString(ohmHardware, OhmHardwareProperty.IDENTIFIER, 0);
            if (cpuIdentifier.length() > 0) {
                StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
                sb.append(" WHERE Parent = \"").append(cpuIdentifier);
                sb.append("\" AND SensorType=\"Temperature\"");
                this.ohmSensorQuery.setWmiClassName(sb.toString());
                WbemcliUtil.WmiResult<OhmSensorProperty> ohmSensors = this.wmiQueryHandler.queryWMI(this.ohmSensorQuery);
                if (ohmSensors.getResultCount() > 0) {
                    double sum = 0.0;
                    for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                        sum += (double)WmiUtils.getFloat(ohmSensors, OhmSensorProperty.VALUE, i);
                    }
                    return sum / (double)ohmSensors.getResultCount();
                }
            }
        }
        return 0.0;
    }

    private double getTempFromPerfCounters() {
        double tempC = 0.0;
        long tempK = 0L;
        Map<ThermalZoneProperty, List<Long>> valueListMap = this.thermalZonePerfCounters.queryValuesWildcard();
        List<Long> valueList = valueListMap.get(ThermalZoneProperty.TEMPERATURE);
        if (valueList != null && !valueList.isEmpty()) {
            Logger.debug("Found Temperature data in PDH or WMI Counter", new Object[0]);
            tempK = valueList.get(0);
        }
        if (tempK > 2732L) {
            tempC = (double)tempK / 10.0 - 273.15;
        } else if (tempK > 274L) {
            tempC = (double)tempK - 273.0;
        }
        return tempC < 0.0 ? 0.0 : tempC;
    }

    @Override
    public int[] queryFanSpeeds() {
        int[] fanSpeeds = this.getFansFromOHM();
        if (fanSpeeds.length > 0) {
            return fanSpeeds;
        }
        fanSpeeds = this.getFansFromWMI();
        if (fanSpeeds.length > 0) {
            return fanSpeeds;
        }
        return new int[0];
    }

    private int[] getFansFromOHM() {
        WbemcliUtil.WmiResult<OhmHardwareProperty> ohmHardware = this.wmiQueryHandler.queryWMI(this.ohmHardwareQuery);
        if (ohmHardware.getResultCount() > 0) {
            Logger.debug("Found Fan data in Open Hardware Monitor", new Object[0]);
            String cpuIdentifier = WmiUtils.getString(ohmHardware, OhmHardwareProperty.IDENTIFIER, 0);
            if (cpuIdentifier.length() > 0) {
                StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
                sb.append(" WHERE Parent = \"").append(cpuIdentifier);
                sb.append("\" AND SensorType=\"Fan\"");
                this.ohmSensorQuery.setWmiClassName(sb.toString());
                WbemcliUtil.WmiResult<OhmSensorProperty> ohmSensors = this.wmiQueryHandler.queryWMI(this.ohmSensorQuery);
                if (ohmSensors.getResultCount() > 0) {
                    int[] fanSpeeds = new int[ohmSensors.getResultCount()];
                    for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                        fanSpeeds[i] = (int)WmiUtils.getFloat(ohmSensors, OhmSensorProperty.VALUE, i);
                    }
                    return fanSpeeds;
                }
            }
        }
        return new int[0];
    }

    private int[] getFansFromWMI() {
        WbemcliUtil.WmiResult<FanProperty> fan = this.wmiQueryHandler.queryWMI(this.fanQuery);
        if (fan.getResultCount() > 1) {
            Logger.debug("Found Fan data in WMI", new Object[0]);
            int[] fanSpeeds = new int[fan.getResultCount()];
            for (int i = 0; i < fan.getResultCount(); ++i) {
                fanSpeeds[i] = (int)WmiUtils.getUint64(fan, FanProperty.DESIREDSPEED, i);
            }
            return fanSpeeds;
        }
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        double volts = this.getVoltsFromOHM();
        if (volts > 0.0) {
            return volts;
        }
        volts = this.getVoltsFromWMI();
        return volts;
    }

    private double getVoltsFromOHM() {
        WbemcliUtil.WmiResult<OhmHardwareProperty> ohmHardware = this.wmiQueryHandler.queryWMI(this.owhVoltageQuery);
        if (ohmHardware.getResultCount() > 0) {
            Logger.debug("Found Voltage data in Open Hardware Monitor", new Object[0]);
            String voltIdentifierStr = null;
            for (int i = 0; i < ohmHardware.getResultCount(); ++i) {
                String id = WmiUtils.getString(ohmHardware, OhmHardwareProperty.IDENTIFIER, i);
                if (!id.toLowerCase().contains("cpu")) continue;
                voltIdentifierStr = id;
                break;
            }
            if (voltIdentifierStr == null) {
                voltIdentifierStr = WmiUtils.getString(ohmHardware, OhmHardwareProperty.IDENTIFIER, 0);
            }
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(voltIdentifierStr);
            sb.append("\" AND SensorType=\"Voltage\"");
            this.ohmSensorQuery.setWmiClassName(sb.toString());
            WbemcliUtil.WmiResult<OhmSensorProperty> ohmSensors = this.wmiQueryHandler.queryWMI(this.ohmSensorQuery);
            if (ohmSensors.getResultCount() > 0) {
                return WmiUtils.getFloat(ohmSensors, OhmSensorProperty.VALUE, 0);
            }
        }
        return 0.0;
    }

    private double getVoltsFromWMI() {
        WbemcliUtil.WmiResult<VoltProperty> voltage = this.wmiQueryHandler.queryWMI(this.voltQuery);
        if (voltage.getResultCount() > 1) {
            Logger.debug("Found Voltage data in WMI", new Object[0]);
            int decivolts = WmiUtils.getUint16(voltage, VoltProperty.CURRENTVOLTAGE, 0);
            if (decivolts > 0) {
                if ((decivolts & 0x80) == 0) {
                    decivolts = WmiUtils.getUint32(voltage, VoltProperty.VOLTAGECAPS, 0);
                    if ((decivolts & 1) > 0) {
                        return 5.0;
                    }
                    if ((decivolts & 2) > 0) {
                        return 3.3;
                    }
                    if ((decivolts & 4) > 0) {
                        return 2.9;
                    }
                } else {
                    return (double)(decivolts & 0x7F) / 10.0;
                }
            }
        }
        return 0.0;
    }

    static enum ThermalZoneProperty implements PerfWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("*cpu*"),
        TEMPERATURE("Temperature");

        private final String counter;

        private ThermalZoneProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    static enum VoltProperty {
        CURRENTVOLTAGE,
        VOLTAGECAPS;

    }

    static enum FanProperty {
        DESIREDSPEED;

    }

    static enum OhmSensorProperty {
        VALUE;

    }

    static enum OhmHardwareProperty {
        IDENTIFIER;

    }
}

