/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import java.util.Map;
import java.util.function.Supplier;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.common.windows.PerfCounterQuery;
import org.aoju.bus.health.hardware.AbstractVirtualMemory;
import org.aoju.bus.logger.Logger;

public class WindowsVirtualMemory
extends AbstractVirtualMemory {
    private final long pageSize;
    private final Supplier<Long> total = Memoizer.memoize(this::querySwapTotal, Memoizer.defaultExpiration());
    private PerfCounterQuery<PageSwapProperty> memoryPerfCounters = new PerfCounterQuery<PageSwapProperty>(PageSwapProperty.class, "Memory", "Win32_PerfRawData_PerfOS_Memory");
    private final Supplier<PagingFile> pagingFile = Memoizer.memoize(this::queryPagingFile, Memoizer.defaultExpiration());
    private PerfCounterQuery<PagingPercentProperty> pagingPerfCounters = new PerfCounterQuery<PagingPercentProperty>(PagingPercentProperty.class, "Paging File", "Win32_PerfRawData_PerfOS_PagingFile");
    private final Supplier<Long> used = Memoizer.memoize(this::querySwapUsed, Memoizer.defaultExpiration());

    public WindowsVirtualMemory(long pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public long getSwapUsed() {
        return this.used.get();
    }

    @Override
    public long getSwapTotal() {
        return this.total.get();
    }

    @Override
    public long getSwapPagesIn() {
        return this.pagingFile.get().pagesIn;
    }

    @Override
    public long getSwapPagesOut() {
        return this.pagingFile.get().pagesOut;
    }

    private long querySwapUsed() {
        Map<PagingPercentProperty, Long> valueMap = this.pagingPerfCounters.queryValues();
        return valueMap.getOrDefault(PagingPercentProperty.PERCENTUSAGE, 0L) * this.pageSize;
    }

    private long querySwapTotal() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            Logger.error("Failed to get Performance Info. Error code: {}", Kernel32.INSTANCE.GetLastError());
            return 0L;
        }
        return this.pageSize * (perfInfo.CommitLimit.longValue() - perfInfo.PhysicalTotal.longValue());
    }

    private PagingFile queryPagingFile() {
        Map<PageSwapProperty, Long> valueMap = this.memoryPerfCounters.queryValues();
        return new PagingFile(valueMap.getOrDefault(PageSwapProperty.PAGESINPUTPERSEC, 0L), valueMap.getOrDefault(PageSwapProperty.PAGESOUTPUTPERSEC, 0L));
    }

    private static final class PagingFile {
        private final long pagesIn;
        private final long pagesOut;

        private PagingFile(long pagesIn, long pagesOut) {
            this.pagesIn = pagesIn;
            this.pagesOut = pagesOut;
        }
    }

    public static enum PageSwapProperty implements PerfCounterQuery.PdhCounterProperty
    {
        PAGESINPUTPERSEC(null, "Pages Input/sec"),
        PAGESOUTPUTPERSEC(null, "Pages Output/sec");

        private final String instance;
        private final String counter;

        private PageSwapProperty(String instance, String counter) {
            this.instance = instance;
            this.counter = counter;
        }

        @Override
        public String getInstance() {
            return this.instance;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    static enum PagingPercentProperty implements PerfCounterQuery.PdhCounterProperty
    {
        PERCENTUSAGE("_Total", "% Usage");

        private final String instance;
        private final String counter;

        private PagingPercentProperty(String instance, String counter) {
            this.instance = instance;
            this.counter = counter;
        }

        @Override
        public String getInstance() {
            return this.instance;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }
}

