/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.software;

import java.util.Collection;
import java.util.List;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.software.FileSystem;
import org.aoju.bus.health.software.NetworkParams;
import org.aoju.bus.health.software.OSProcess;
import org.aoju.bus.health.software.OSService;

public interface OperatingSystem {
    public String getFamily();

    public String getManufacturer();

    public OSVersionInfo getVersionInfo();

    public FileSystem getFileSystem();

    public OSProcess[] getProcesses();

    public OSProcess[] getProcesses(int var1, ProcessSort var2);

    public OSProcess[] getProcesses(int var1, ProcessSort var2, boolean var3);

    public List<OSProcess> getProcesses(Collection<Integer> var1);

    public List<OSProcess> getProcesses(Collection<Integer> var1, boolean var2);

    public OSProcess getProcess(int var1);

    public OSProcess getProcess(int var1, boolean var2);

    public OSProcess[] getChildProcesses(int var1, int var2, ProcessSort var3);

    public long getProcessAffinityMask(int var1);

    public int getProcessId();

    public int getProcessCount();

    public int getThreadCount();

    public int getBitness();

    public long getSystemUptime();

    public long getSystemBootTime();

    public boolean isElevated();

    public NetworkParams getNetworkParams();

    public OSService[] getServices();

    public static class OSVersionInfo {
        private final String version;
        private final String codeName;
        private final String buildNumber;
        private final String versionStr;

        public OSVersionInfo(String version, String codeName, String buildNumber) {
            this.version = version;
            this.codeName = codeName;
            this.buildNumber = buildNumber;
            StringBuilder sb = new StringBuilder(this.getVersion() != null ? this.getVersion() : "unknown");
            if (!StringUtils.isBlank(this.getCodeName())) {
                sb.append(" (").append(this.getCodeName()).append(')');
            }
            if (!StringUtils.isBlank(this.getBuildNumber())) {
                sb.append(" build ").append(this.getBuildNumber());
            }
            this.versionStr = sb.toString();
        }

        public String getVersion() {
            return this.version;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String toString() {
            return this.versionStr;
        }
    }

    public static enum ProcessSort {
        CPU,
        MEMORY,
        OLDEST,
        NEWEST,
        PID,
        PARENTPID,
        NAME;

    }
}

