/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.bodys;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.consts.MediaType;
import org.aoju.bus.core.io.segment.Buffer;
import org.aoju.bus.core.io.segment.BufferSource;
import org.aoju.bus.core.io.segment.ByteString;
import org.aoju.bus.http.Internal;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    public static ResponseBody create(MediaType contentType, String content) {
        java.nio.charset.Charset charset = Charset.UTF_8;
        if (contentType != null && (charset = contentType.charset()) == null) {
            charset = Charset.UTF_8;
            contentType = MediaType.valueOf(contentType + "; charset=utf-8");
        }
        Buffer buffer = new Buffer().writeString(content, charset);
        return ResponseBody.create(contentType, buffer.size(), buffer);
    }

    public static ResponseBody create(MediaType contentType, byte[] content) {
        Buffer buffer = new Buffer().write(content);
        return ResponseBody.create(contentType, content.length, buffer);
    }

    public static ResponseBody create(MediaType contentType, ByteString content) {
        Buffer buffer = new Buffer().write(content);
        return ResponseBody.create(contentType, content.size(), buffer);
    }

    public static ResponseBody create(final MediaType contentType, final long contentLength, final BufferSource content) {
        if (content == null) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() {
                return contentLength;
            }

            @Override
            public BufferSource source() {
                return content;
            }
        };
    }

    public abstract MediaType contentType();

    public abstract long contentLength();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferSource source();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] bytes() throws IOException {
        byte[] bytes;
        long contentLength = this.contentLength();
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + contentLength);
        }
        BufferSource source = this.source();
        try {
            bytes = source.readByteArray();
        }
        finally {
            Internal.closeQuietly(source);
        }
        if (contentLength != -1L && contentLength != (long)bytes.length) {
            throw new IOException("Content-Length (" + contentLength + ") and stream length (" + bytes.length + ") disagree");
        }
        return bytes;
    }

    public final Reader charStream() {
        Reader r = this.reader;
        return r != null ? r : (this.reader = new BomAwareReader(this.source(), this.charset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String string() throws IOException {
        BufferSource source = this.source();
        try {
            java.nio.charset.Charset charset = Internal.bomAwareCharset(source, this.charset());
            String string = source.readString(charset);
            return string;
        }
        finally {
            Internal.closeQuietly(source);
        }
    }

    private java.nio.charset.Charset charset() {
        MediaType contentType = this.contentType();
        return contentType != null ? contentType.charset(Charset.UTF_8) : Charset.UTF_8;
    }

    @Override
    public void close() {
        Internal.closeQuietly(this.source());
    }

    static final class BomAwareReader
    extends Reader {
        private final BufferSource source;
        private final java.nio.charset.Charset charset;
        private boolean closed;
        private Reader delegate;

        BomAwareReader(BufferSource source, java.nio.charset.Charset charset) {
            this.source = source;
            this.charset = charset;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            Reader delegate = this.delegate;
            if (delegate == null) {
                java.nio.charset.Charset charset = Internal.bomAwareCharset(this.source, this.charset);
                delegate = this.delegate = new InputStreamReader(this.source.inputStream(), charset);
            }
            return delegate.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.delegate != null) {
                this.delegate.close();
            } else {
                this.source.close();
            }
        }
    }
}

