/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class MeituanProvider
extends DefaultProvider {
    public MeituanProvider(Context context) {
        super(context, Registry.MEITUAN);
    }

    public MeituanProvider(Context context, StateCache stateCache) {
        super(context, Registry.MEITUAN, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.context.getClientId());
        params.put("secret", this.context.getClientSecret());
        params.put("code", Callback2.getCode());
        params.put("grant_type", "authorization_code");
        String response = HttpClient.post(this.source.accessToken(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.context.getClientId());
        params.put("secret", this.context.getClientSecret());
        params.put("access_token", token.getAccessToken());
        String response = HttpClient.post(this.source.refresh(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("openid")).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("avatar")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken oldToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.context.getClientId());
        params.put("secret", this.context.getClientSecret());
        params.put("refresh_token", oldToken.getRefreshToken());
        params.put("grant_type", "refresh_token");
        String response = HttpClient.post(this.source.refresh(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).build()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error_code")) {
            throw new InstrumentException(object.getString("erroe_msg"));
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("app_id", this.context.getClientId()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("scope", "").build();
    }
}

