/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.registry;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.office.magic.Formats;
import org.aoju.bus.office.registry.SimpleFormatRegistry;

public class JsonFormatRegistry
extends SimpleFormatRegistry {
    public JsonFormatRegistry(InputStream input) throws IOException {
        this.readJsonArray(IoUtils.toString(input, "UTF-8"));
    }

    public JsonFormatRegistry(String source) {
        this.readJsonArray(source);
    }

    private void readJsonArray(String source) {
        JSONArray array = JSONArray.parseArray((String)source);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonFormat = array.getJSONObject(i);
            Formats format = new Formats();
            format.setName(jsonFormat.getString("name"));
            format.setExtension(jsonFormat.getString("extension"));
            format.setMediaType(jsonFormat.getString("mediaType"));
            if (jsonFormat.containsKey((Object)"inputFamily")) {
                format.setInputFamily(Formats.Type.valueOf(jsonFormat.getString("inputFamily")));
            }
            if (jsonFormat.containsKey((Object)"loadProperties")) {
                format.setLoadProperties(this.toJavaMap(jsonFormat.getJSONObject("loadProperties")));
            }
            if (jsonFormat.containsKey((Object)"storePropertiesByFamily")) {
                JSONObject jsonStorePropertiesByFamily = jsonFormat.getJSONObject("storePropertiesByFamily");
                for (Map.Entry entry : jsonStorePropertiesByFamily.entrySet()) {
                    Map<String, ?> storeProperties = this.toJavaMap(jsonStorePropertiesByFamily.getJSONObject((String)entry.getKey()));
                    format.setStoreProperties(Formats.Type.valueOf((String)entry.getKey()), storeProperties);
                }
            }
            this.addFormat(format);
        }
    }

    private Map<String, ?> toJavaMap(JSONObject jsonMap) {
        HashMap map = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            Object value = jsonMap.get(entry.getKey());
            if (value instanceof JSONObject) {
                map.put(entry.getKey(), this.toJavaMap((JSONObject)value));
                continue;
            }
            map.put(entry.getKey(), value);
        }
        return map;
    }
}

