/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support;

import java.io.File;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Manager;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.process.LinuxProcessManager;
import org.aoju.bus.office.process.PureJavaProcessManager;
import org.aoju.bus.office.support.ConnectionProtocol;
import org.aoju.bus.office.support.ProcessManager;

public class DefaultConfiguration {
    public static final long DEFAULT_RETRY_TIMEOUT = 120000L;
    private File officeHome = Builder.getDefaultOfficeHome();
    private ConnectionProtocol connectionProtocol = ConnectionProtocol.SOCKET;
    private int[] portNumbers = new int[]{2002};
    private String[] pipeNames = new String[]{"office"};
    private String[] runAsArgs = null;
    private File templateProfileDir = null;
    private File workDir = new File(System.getProperty("java.io.tmpdir"));
    private long taskQueueTimeout = 30000L;
    private long taskExecutionTimeout = 120000L;
    private int maxTasksPerProcess = 200;
    private long retryTimeout = 120000L;
    private org.aoju.bus.office.process.ProcessManager processManager = null;

    public DefaultConfiguration setOfficeHome(String officeHome) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("officeHome", officeHome);
        return this.setOfficeHome(new File(officeHome));
    }

    public DefaultConfiguration setOfficeHome(File officeHome) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("officeHome", officeHome);
        this.checkArgument("officeHome", officeHome.isDirectory(), "must exist and be a directory");
        this.officeHome = officeHome;
        return this;
    }

    public DefaultConfiguration setConnectionProtocol(ConnectionProtocol connectionProtocol) throws NullPointerException {
        this.checkArgumentNotNull("connectionProtocol", (Object)connectionProtocol);
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public DefaultConfiguration setPortNumber(int portNumber) {
        this.portNumbers = new int[]{portNumber};
        return this;
    }

    public DefaultConfiguration setPortNumbers(int ... portNumbers) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("portNumbers", portNumbers);
        this.checkArgument("portNumbers", portNumbers.length > 0, "must not be empty");
        this.portNumbers = portNumbers;
        return this;
    }

    public DefaultConfiguration setPipeName(String pipeName) throws NullPointerException {
        this.checkArgumentNotNull("pipeName", pipeName);
        this.pipeNames = new String[]{pipeName};
        return this;
    }

    public DefaultConfiguration setPipeNames(String ... pipeNames) throws NullPointerException, IllegalArgumentException {
        this.checkArgumentNotNull("pipeNames", pipeNames);
        this.checkArgument("pipeNames", pipeNames.length > 0, "must not be empty");
        this.pipeNames = pipeNames;
        return this;
    }

    public DefaultConfiguration setRunAsArgs(String ... runAsArgs) {
        this.runAsArgs = runAsArgs;
        return this;
    }

    public DefaultConfiguration setTemplateProfileDir(File templateProfileDir) throws IllegalArgumentException {
        if (templateProfileDir != null) {
            this.checkArgument("templateProfileDir", templateProfileDir.isDirectory(), "must exist and be a directory");
        }
        this.templateProfileDir = templateProfileDir;
        return this;
    }

    public DefaultConfiguration setWorkDir(File workDir) {
        this.checkArgumentNotNull("workDir", workDir);
        this.workDir = workDir;
        return this;
    }

    public DefaultConfiguration setTaskQueueTimeout(long taskQueueTimeout) {
        this.taskQueueTimeout = taskQueueTimeout;
        return this;
    }

    public DefaultConfiguration setTaskExecutionTimeout(long taskExecutionTimeout) {
        this.taskExecutionTimeout = taskExecutionTimeout;
        return this;
    }

    public DefaultConfiguration setMaxTasksPerProcess(int maxTasksPerProcess) {
        this.maxTasksPerProcess = maxTasksPerProcess;
        return this;
    }

    public DefaultConfiguration setProcessManager(org.aoju.bus.office.process.ProcessManager processManager) throws NullPointerException {
        this.checkArgumentNotNull("processManager", processManager);
        this.processManager = processManager;
        return this;
    }

    public DefaultConfiguration setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    public Manager buildOfficeManager() throws IllegalStateException {
        if (this.officeHome == null) {
            throw new IllegalStateException("officeHome not set and could not be auto-detected");
        }
        if (!this.officeHome.isDirectory()) {
            throw new IllegalStateException("officeHome doesn't exist or is not a directory: " + this.officeHome);
        }
        if (!Builder.getOfficeExecutable(this.officeHome).isFile()) {
            throw new IllegalStateException("invalid officeHome: it doesn't contain soffice.bin: " + this.officeHome);
        }
        if (this.templateProfileDir != null && !this.isValidProfileDir(this.templateProfileDir)) {
            throw new IllegalStateException("templateProfileDir doesn't appear to contain a user profile: " + this.templateProfileDir);
        }
        if (!this.workDir.isDirectory()) {
            throw new IllegalStateException("workDir doesn't exist or is not a directory: " + this.workDir);
        }
        if (this.processManager == null) {
            this.processManager = this.findBestProcessManager();
        }
        int numInstances = this.connectionProtocol == ConnectionProtocol.PIPE ? this.pipeNames.length : this.portNumbers.length;
        UnoUrl[] unoUrls = new UnoUrl[numInstances];
        for (int i = 0; i < numInstances; ++i) {
            unoUrls[i] = this.connectionProtocol == ConnectionProtocol.PIPE ? UnoUrl.pipe(this.pipeNames[i]) : UnoUrl.socket(this.portNumbers[i]);
        }
        return new ProcessManager(this.officeHome, unoUrls, this.runAsArgs, this.templateProfileDir, this.workDir, this.retryTimeout, this.taskQueueTimeout, this.taskExecutionTimeout, this.maxTasksPerProcess, this.processManager);
    }

    private org.aoju.bus.office.process.ProcessManager findBestProcessManager() {
        if (Builder.isLinux()) {
            LinuxProcessManager processManager = new LinuxProcessManager();
            if (this.runAsArgs != null) {
                processManager.setRunAsArgs(this.runAsArgs);
            }
            return processManager;
        }
        return new PureJavaProcessManager();
    }

    private void checkArgumentNotNull(String argName, Object argValue) throws NullPointerException {
        if (argValue == null) {
            throw new NullPointerException(argName + " must not be null");
        }
    }

    private void checkArgument(String argName, boolean condition, String message) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(argName + " " + message);
        }
    }

    private boolean isValidProfileDir(File profileDir) {
        return new File(profileDir, "user").isDirectory();
    }
}

