/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support;

import org.aoju.bus.office.Manager;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.support.ConnectionProtocol;
import org.aoju.bus.office.support.ExternalManager;

public class ExternalConfiguration {
    private ConnectionProtocol connectionProtocol = ConnectionProtocol.SOCKET;
    private int portNumber = 2002;
    private String pipeName = "office";
    private boolean connectOnStart = true;

    public ExternalConfiguration setConnectionProtocol(ConnectionProtocol connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public ExternalConfiguration setPortNumber(int portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public ExternalConfiguration setPipeName(String pipeName) {
        this.pipeName = pipeName;
        return this;
    }

    public ExternalConfiguration setConnectOnStart(boolean connectOnStart) {
        this.connectOnStart = connectOnStart;
        return this;
    }

    public Manager buildOfficeManager() {
        UnoUrl unoUrl = this.connectionProtocol == ConnectionProtocol.SOCKET ? UnoUrl.socket(this.portNumber) : UnoUrl.pipe(this.pipeName);
        return new ExternalManager(unoUrl, this.connectOnStart);
    }
}

