/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.File;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.office.support.excel.BookUtils;
import org.aoju.bus.office.support.excel.ExcelWriter;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BigExcelWriter
extends ExcelWriter {
    public static final int DEFAULT_WINDOW_SIZE = 100;

    public BigExcelWriter() {
        this(100);
    }

    public BigExcelWriter(int rowAccessWindowSize) {
        this(BookUtils.createSXSSFBook(rowAccessWindowSize), null);
    }

    public BigExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public BigExcelWriter(int rowAccessWindowSize, String sheetName) {
        this(BookUtils.createSXSSFBook(rowAccessWindowSize), sheetName);
    }

    public BigExcelWriter(String destFilePath, String sheetName) {
        this(FileUtils.file(destFilePath), sheetName);
    }

    public BigExcelWriter(File destFile) {
        this(destFile, null);
    }

    public BigExcelWriter(File destFile, String sheetName) {
        this(destFile.exists() ? BookUtils.createSXSSFBook(destFile) : BookUtils.createSXSSFBook(), sheetName);
        this.destFile = destFile;
    }

    public BigExcelWriter(SXSSFWorkbook workbook, String sheetName) {
        this(BookUtils.getOrCreateSheet((Workbook)workbook, sheetName));
    }

    public BigExcelWriter(Sheet sheet) {
        super(sheet);
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        ((SXSSFWorkbook)this.workbook).dispose();
        super.closeWithoutFlush();
    }
}

