/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.word;

import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IterUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class TableUtils {
    public static XWPFTable createTable(XWPFDocument doc) {
        return TableUtils.createTable(doc, null);
    }

    public static XWPFTable createTable(XWPFDocument doc, Iterable<?> data) {
        Assert.notNull(doc, "XWPFDocument must be not null !", new Object[0]);
        XWPFTable table = doc.createTable();
        if (IterUtils.isEmpty(data)) {
            return table;
        }
        int index = 0;
        for (Object rowData : data) {
            TableUtils.writeRow(TableUtils.getOrCreateRow(table, index), rowData, true);
            ++index;
        }
        return table;
    }

    public static void writeRow(XWPFTableRow row, Object rowBean, boolean isWriteKeyAsHead) {
        if (rowBean instanceof Iterable) {
            TableUtils.writeRow(row, (Iterable)rowBean);
        }
        Map<String, Object> rowMap = null;
        if (rowBean instanceof Map) {
            rowMap = (Map<String, Object>)rowBean;
        } else if (BeanUtils.isBean(rowBean.getClass())) {
            rowMap = BeanUtils.beanToMap(rowBean, new LinkedHashMap<String, Object>(), false, false);
        } else {
            TableUtils.writeRow(row, CollUtils.newArrayList(rowBean), isWriteKeyAsHead);
        }
        TableUtils.writeRow(row, rowMap, isWriteKeyAsHead);
    }

    public static void writeRow(XWPFTableRow row, Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        if (MapUtils.isEmpty(rowMap)) {
            return;
        }
        if (isWriteKeyAsHead) {
            TableUtils.writeRow(row, rowMap.keySet());
        }
        TableUtils.writeRow(row, rowMap.values());
    }

    public static void writeRow(XWPFTableRow row, Iterable<?> rowData) {
        int index = 0;
        for (Object cellData : rowData) {
            XWPFTableCell cell = TableUtils.getOrCreateCell(row, index);
            cell.setText(Convert.toString(cellData));
            ++index;
        }
    }

    public static XWPFTableRow getOrCreateRow(XWPFTable table, int index) {
        XWPFTableRow row = table.getRow(index);
        if (null == row) {
            row = table.createRow();
        }
        return row;
    }

    public static XWPFTableCell getOrCreateCell(XWPFTableRow row, int index) {
        XWPFTableCell cell = row.getCell(index);
        if (null == cell) {
            cell = row.createCell();
        }
        return cell;
    }
}

