/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.druid;

import java.lang.reflect.Method;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.druid.DataSource;
import org.aoju.bus.starter.druid.DataSourceHolder;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

@Order(value=-1)
@Aspect
public class AspectjDruidProxy {
    @Pointcut(value="@annotation(org.aoju.bus.starter.druid.DataSource)||execution(* *(@org.aoju.bus.starter.druid.DataSource (*), ..))")
    public void match() {
    }

    @Around(value="match()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        DataSource dataSource = method.getAnnotation(DataSource.class);
        if (!StringUtils.hasLength(dataSource.value())) {
            dataSource = method.getDeclaringClass().getAnnotation(DataSource.class);
        }
        if (null != dataSource) {
            DataSourceHolder.setKey(dataSource.value());
            Logger.info("Switch datasource to [{}] in method [{}]", DataSourceHolder.getKey(), point.getSignature());
        }
        Object object = point.proceed();
        DataSourceHolder.remove();
        Logger.info("Restore datasource to [{}] in method [{}]", DataSourceHolder.getKey(), point.getSignature());
        return object;
    }
}

