/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.provider;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Provider;
import org.aoju.bus.crypto.asymmetric.KeyType;
import org.aoju.bus.crypto.asymmetric.RSA;

public class RSAProvider
implements Provider {
    @Override
    public byte[] encrypt(String key, byte[] content) {
        if (StringUtils.isEmpty(key)) {
            throw new InstrumentException("key is null!");
        }
        String[] array = StringUtils.split((CharSequence)key, ",");
        RSA rsa = Builder.rsa(array[0], array[1]);
        return rsa.encrypt(content, KeyType.valueOf(array[2]));
    }

    @Override
    public byte[] decrypt(String key, byte[] content) {
        if (StringUtils.isEmpty(key)) {
            throw new InstrumentException("key is null!");
        }
        String[] array = StringUtils.split((CharSequence)key, ",");
        RSA rsa = Builder.rsa(array[0], array[1]);
        return rsa.decrypt(content, KeyType.valueOf(array[2]));
    }
}

