/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aoju.bus.logger.Logger;

public class Command {
    private Command() {
    }

    public static List<String> runNative(String cmdToRun) {
        String[] cmd = cmdToRun.split(" ");
        return Command.runNative(cmd);
    }

    public static List<String> runNative(String[] cmdToRunWithArgs) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdToRunWithArgs);
        }
        catch (IOException | SecurityException e) {
            Logger.trace("Couldn't run command {}: {}", Arrays.toString(cmdToRunWithArgs), e);
            return new ArrayList<String>(0);
        }
        ArrayList<String> sa = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
            String line;
            while ((line = reader.readLine()) != null) {
                sa.add(line);
            }
            p.waitFor();
        }
        catch (IOException e) {
            Logger.trace("Problem reading output from {}: {}", Arrays.toString(cmdToRunWithArgs), e);
            return new ArrayList<String>(0);
        }
        catch (InterruptedException ie) {
            Logger.trace("Interrupted while reading output from {}: {}", Arrays.toString(cmdToRunWithArgs), ie);
            Thread.currentThread().interrupt();
        }
        return sa;
    }

    public static String getFirstAnswer(String cmd2launch) {
        return Command.getAnswerAt(cmd2launch, 0);
    }

    public static String getAnswerAt(String cmd2launch, int answerIdx) {
        List<String> sa = Command.runNative(cmd2launch);
        if (answerIdx >= 0 && answerIdx < sa.size()) {
            return sa.get(answerIdx);
        }
        return "";
    }
}

