/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Systemd;
import org.aoju.bus.health.hardware.linux.LinuxNetworks;
import org.aoju.bus.health.hardware.mac.MacNetworks;
import org.aoju.bus.health.hardware.unix.freebsd.FreeBsdNetworks;
import org.aoju.bus.health.hardware.unix.solaris.SolarisNetworks;
import org.aoju.bus.health.hardware.windows.WindowsNetworks;
import org.aoju.bus.logger.Logger;

public class NetworkIF {
    private NetworkInterface networkInterface;
    private int mtu;
    private String mac;
    private String[] ipv4;
    private String[] ipv6;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long speed;
    private long timeStamp;

    public NetworkInterface queryNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(NetworkInterface networkInterface) {
        this.networkInterface = networkInterface;
        try {
            this.mtu = networkInterface.getMTU();
            byte[] hwmac = networkInterface.getHardwareAddress();
            if (hwmac != null) {
                ArrayList<String> octets = new ArrayList<String>(6);
                for (byte b : hwmac) {
                    octets.add(String.format("%02x", b));
                }
                this.mac = String.join((CharSequence)":", octets);
            } else {
                this.mac = "Unknown";
            }
            ArrayList<String> ipv4list = new ArrayList<String>();
            ArrayList<String> ipv6list = new ArrayList<String>();
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                if (address.getHostAddress().length() <= 0) continue;
                if (address.getHostAddress().contains(":")) {
                    ipv6list.add(address.getHostAddress().split("%")[0]);
                    continue;
                }
                ipv4list.add(address.getHostAddress());
            }
            this.ipv4 = ipv4list.toArray(new String[0]);
            this.ipv6 = ipv6list.toArray(new String[0]);
        }
        catch (SocketException e) {
            Logger.error("Socket exception: {}", e);
        }
    }

    public String getName() {
        return this.networkInterface.getName();
    }

    public String getDisplayName() {
        return this.networkInterface.getDisplayName();
    }

    public int getMTU() {
        return this.mtu;
    }

    public String getMacaddr() {
        return this.mac;
    }

    public String[] getIPv4addr() {
        return Arrays.copyOf(this.ipv4, this.ipv4.length);
    }

    public String[] getIPv6addr() {
        return Arrays.copyOf(this.ipv6, this.ipv6.length);
    }

    public long getBytesRecv() {
        return this.bytesRecv;
    }

    public void setBytesRecv(long bytesRecv) {
        this.bytesRecv = Builder.unsignedLongToSignedLong(bytesRecv);
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = Builder.unsignedLongToSignedLong(bytesSent);
    }

    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    public void setPacketsRecv(long packetsRecv) {
        this.packetsRecv = Builder.unsignedLongToSignedLong(packetsRecv);
    }

    public long getPacketsSent() {
        return this.packetsSent;
    }

    public void setPacketsSent(long packetsSent) {
        this.packetsSent = Builder.unsignedLongToSignedLong(packetsSent);
    }

    public long getInErrors() {
        return this.inErrors;
    }

    public void setInErrors(long inErrors) {
        this.inErrors = Builder.unsignedLongToSignedLong(inErrors);
    }

    public long getOutErrors() {
        return this.outErrors;
    }

    public void setOutErrors(long outErrors) {
        this.outErrors = Builder.unsignedLongToSignedLong(outErrors);
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSpeed(long speed) {
        this.speed = Builder.unsignedLongToSignedLong(speed);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void updateAttributes() {
        switch (Systemd.getCurrentPlatform()) {
            case WINDOWS: {
                WindowsNetworks.updateNetworkStats(this);
                break;
            }
            case LINUX: {
                LinuxNetworks.updateNetworkStats(this);
                break;
            }
            case MACOSX: {
                MacNetworks.updateNetworkStats(this);
                break;
            }
            case SOLARIS: {
                SolarisNetworks.updateNetworkStats(this);
                break;
            }
            case FREEBSD: {
                FreeBsdNetworks.updateNetworkStats(this);
                break;
            }
            default: {
                Logger.error("Unsupported platform. No update performed.", new Object[0]);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.getName()).append(" ").append("(").append(this.getDisplayName()).append(")").append("\n");
        sb.append("  MAC Address: ").append(this.getMacaddr()).append("\n");
        sb.append("  MTU: ").append(this.getMTU()).append(", ").append("Speed: ").append(this.getSpeed()).append("\n");
        sb.append("  IPv4: ").append(Arrays.toString(this.getIPv4addr())).append("\n");
        sb.append("  IPv6: ").append(Arrays.toString(this.getIPv6addr())).append("\n");
        sb.append("  Traffic: received ").append(this.getPacketsRecv()).append(" packets/").append(Builder.formatBytes(this.getBytesRecv())).append(" (" + this.getInErrors() + " err);");
        sb.append(" transmitted ").append(this.getPacketsSent()).append(" packets/").append(Builder.formatBytes(this.getBytesSent())).append(" (" + this.getOutErrors() + " err)");
        return sb.toString();
    }
}

