/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class WeChatProvider
extends DefaultProvider {
    public WeChatProvider(Context context) {
        super(context, Registry.WECHAT);
    }

    public WeChatProvider(Context context, StateCache stateCache) {
        super(context, Registry.WECHAT, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return this.getToken(this.accessTokenUrl(Callback2.getCode()));
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        String openId = token.getOpenId();
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        String location = String.format("%s-%s-%s", object.getString("country"), object.getString("province"), object.getString("city"));
        if (object.containsKey((Object)"unionid")) {
            token.setUnionId(object.getString("unionid"));
        }
        return Property.builder().username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("headimgurl")).location(location).uuid(openId).gender(Normal.Gender.getGender(object.getString("sex"))).token(token).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken oldToken) {
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(oldToken.getRefreshToken()))).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"errcode")) {
            throw new InstrumentException(StringUtils.toString(object.getIntValue("errcode")), object.getString("errmsg"));
        }
    }

    private AccToken getToken(String accessTokenUrl) {
        JSONObject object = JSONObject.parseObject((String)HttpClient.get(accessTokenUrl));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).openId(object.getString("openid")).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("appid", this.context.getClientId()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "snsapi_login").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("appid", this.context.getClientId()).queryParam("secret", this.context.getClientSecret()).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("openid", token.getOpenId()).queryParam("lang", "zh_CN").build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromBaseUrl(this.source.refresh()).queryParam("appid", this.context.getClientId()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").build();
    }
}

