/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class WeiboProvider
extends DefaultProvider {
    public WeiboProvider(Context context) {
        super(context, Registry.WEIBO);
    }

    public WeiboProvider(Context context, StateCache stateCache) {
        super(context, Registry.WEIBO, stateCache);
    }

    public static String getLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(Callback2.getCode()));
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getString("error_description"));
        }
        return AccToken.builder().accessToken(object.getString("access_token")).uid(object.getString("uid")).openId(object.getString("uid")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "OAuth2 " + String.format("uid=%s&access_token=%s", token.getUid(), token.getAccessToken()));
        header.put("API-RemoteIP", WeiboProvider.getLocalIp());
        String response = HttpClient.get(this.userInfoUrl(token), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getString("error"));
        }
        return Property.builder().uuid(object.getString("id")).username(object.getString("name")).avatar(object.getString("profile_image_url")).blog(StringUtils.isEmpty(object.getString("url")) ? "https://weibo.com/" + object.getString("profile_url") : object.getString("url")).nickname(object.getString("screen_name")).location(object.getString("location")).remark(object.getString("description")).gender(Normal.Gender.getGender(object.getString("gender"))).token(token).source(this.source.toString()).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("uid", token.getUid()).build();
    }
}

