/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office;

import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.UnoRuntime;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.utils.StringUtils;

public class Builder {
    public static final String SERVICE_DESKTOP = "com.sun.star.frame.Desktop";
    public static final String OFFICE_HOME_KEY = "office.home";
    public static final String DEFAULT_OFFICE_HOME_VALUE = "default";

    public static <T> T cast(Class<T> type, Object object) {
        return (T)UnoRuntime.queryInterface(type, (Object)object);
    }

    public static PropertyValue property(String name, Object value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = name;
        propertyValue.Value = value;
        return propertyValue;
    }

    public static PropertyValue[] toUnoProperties(Map<String, ?> properties) {
        PropertyValue[] propertyValues = new PropertyValue[properties.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map subProperties = (Map)value;
                value = Builder.toUnoProperties(subProperties);
            }
            propertyValues[i++] = Builder.property(entry.getKey(), value);
        }
        return propertyValues;
    }

    public static String toUrl(File file) {
        String path = file.toURI().getRawPath();
        String url = path.startsWith("//") ? "file:" + path : "file://" + path;
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public static File getDefaultOfficeHome() {
        Properties properties = new Properties();
        String customizedConfigPath = Builder.getCustomizedConfigPath();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(customizedConfigPath));
            properties.load(bufferedReader);
            Builder.restorePropertiesFromEnvFormat(properties);
        }
        catch (Exception bufferedReader) {
            // empty catch block
        }
        String officeHome = properties.getProperty(OFFICE_HOME_KEY);
        if (officeHome != null && !DEFAULT_OFFICE_HOME_VALUE.equals(officeHome)) {
            return new File(officeHome);
        }
        if (Builder.isWindows()) {
            String homePath = Builder.getHomePath();
            String programFiles = System.getenv("ProgramFiles(x86)");
            if (StringUtils.isEmpty(programFiles)) {
                programFiles = System.getenv("ProgramFiles");
            }
            return Builder.findOfficeHome(programFiles + File.separator + "OpenOffice 4", programFiles + File.separator + "LibreOffice 4", homePath + File.separator + "office");
        }
        if (Builder.isMac()) {
            return Builder.findOfficeHome("/Applications/OpenOffice.org.app/Contents", "/Applications/OpenOffice.app/Contents", "/Applications/LibreOffice.app/Contents");
        }
        return Builder.findOfficeHome("/opt/openoffice.org3", "/opt/openoffice", "/opt/libreoffice", "/opt/openoffice4", "/usr/lib/openoffice", "/usr/lib/libreoffice");
    }

    private static File findOfficeHome(String ... knownPaths) {
        for (String path : knownPaths) {
            File home = new File(path);
            if (!Builder.getOfficeExecutable(home).isFile()) continue;
            return home;
        }
        return null;
    }

    public static File getOfficeExecutable(File officeHome) {
        if (Builder.isMac()) {
            return new File(officeHome, "MacOS/soffice");
        }
        return new File(officeHome, "program/soffice.bin");
    }

    public static String getHomePath() {
        String userDir = System.getenv("KKFILEVIEW_BIN_FOLDER");
        if (userDir == null) {
            userDir = System.getProperty("user.dir");
        }
        if (userDir.endsWith("bin")) {
            userDir = userDir.substring(0, userDir.length() - 4);
        } else {
            String separator = File.separator;
            userDir = userDir.contains("bus-online") ? userDir + separator + "src" + separator + "main" : userDir + separator + "bus-online" + separator + "src" + separator + "main";
        }
        return userDir;
    }

    public static String getCustomizedConfigPath() {
        String homePath = Builder.getHomePath();
        String separator = File.separator;
        String configFilePath = homePath + separator + "config" + separator + "application.properties";
        return configFilePath;
    }

    public static synchronized void restorePropertiesFromEnvFormat(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!value.trim().startsWith("${") || !value.trim().endsWith("}")) continue;
            int beginIndex = value.indexOf(":");
            if (beginIndex < 0) {
                beginIndex = value.length() - 1;
            }
            int endIndex = value.length() - 1;
            String envKey = value.substring(2, beginIndex);
            String envValue = System.getenv(envKey);
            value = envValue == null || "".equals(envValue.trim()) ? value.substring(beginIndex + 1, endIndex) : envValue;
            properties.setProperty(key, value);
        }
    }

    public static boolean isLinux() {
        return "linux".endsWith(System.getProperty("os.name"));
    }

    public static boolean isMac() {
        return "mac".endsWith(System.getProperty("os.name"));
    }

    public static boolean isWindows() {
        return "windows".endsWith(System.getProperty("os.name"));
    }
}

