/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Retryable;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.process.ProcessManager;
import org.aoju.bus.office.support.ProcessQuery;

public class Process {
    private final File officeHome;
    private final UnoUrl unoUrl;
    private final String[] runAsArgs;
    private final File templateProfileDir;
    private final File instanceProfileDir;
    private final ProcessManager processManager;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private java.lang.Process process;
    private long pid = -1L;

    public Process(File officeHome, UnoUrl unoUrl, String[] runAsArgs, File templateProfileDir, File workDir, ProcessManager processManager) {
        this.officeHome = officeHome;
        this.unoUrl = unoUrl;
        this.runAsArgs = runAsArgs;
        this.templateProfileDir = templateProfileDir;
        this.instanceProfileDir = this.getInstanceProfileDir(workDir, unoUrl);
        this.processManager = processManager;
    }

    public void start() throws IOException {
        this.start(false);
    }

    public void start(boolean restart) throws IOException {
        ProcessQuery processQuery = new ProcessQuery("soffice.bin", this.unoUrl.getAcceptString());
        long existingPid = this.processManager.findPid(processQuery);
        if (existingPid != -2L && existingPid != -1L) {
            throw new IllegalStateException(String.format("a process with acceptString '%s' is already running; pid %d", this.unoUrl.getAcceptString(), existingPid));
        }
        if (!restart) {
            this.prepareInstanceProfileDir();
        }
        ArrayList<String> command = new ArrayList<String>();
        File executable = Builder.getOfficeExecutable(this.officeHome);
        if (this.runAsArgs != null) {
            command.addAll(Arrays.asList(this.runAsArgs));
        }
        command.add(executable.getAbsolutePath());
        command.add("-accept=" + this.unoUrl.getAcceptString() + ";urp;");
        command.add("-env:UserInstallation=" + Builder.toUrl(this.instanceProfileDir));
        command.add("-headless");
        command.add("-nocrashreport");
        command.add("-nodefault");
        command.add("-nofirststartwizard");
        command.add("-nolockcheck");
        command.add("-nologo");
        command.add("-norestore");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (Builder.isWindows()) {
            this.addBasisAndUrePaths(processBuilder);
        }
        this.logger.info(String.format("starting process with acceptString '%s' and profileDir '%s'", this.unoUrl, this.instanceProfileDir));
        this.process = processBuilder.start();
        this.pid = this.processManager.findPid(processQuery);
        if (this.pid == -2L) {
            throw new IllegalStateException(String.format("process with acceptString '%s' started but its pid could not be found", this.unoUrl.getAcceptString()));
        }
        this.logger.info("started process" + (this.pid != -1L ? "; pid = " + this.pid : ""));
    }

    private File getInstanceProfileDir(File workDir, UnoUrl unoUrl) {
        String dirName = ".jodconverter_" + unoUrl.getAcceptString().replace(',', '_').replace('=', '-');
        return new File(workDir, dirName);
    }

    private void prepareInstanceProfileDir() throws InstrumentException {
        if (this.instanceProfileDir.exists()) {
            this.logger.warning(String.format("profile dir '%s' already exists; deleting", this.instanceProfileDir));
            this.deleteProfileDir();
        }
        if (this.templateProfileDir != null) {
            try {
                FileUtils.copy(this.templateProfileDir, this.instanceProfileDir, true);
            }
            catch (InstrumentException ex) {
                throw new InstrumentException("failed to create profileDir", ex);
            }
        }
    }

    public void deleteProfileDir() {
        if (this.instanceProfileDir != null) {
            try {
                FileUtils.clean(this.instanceProfileDir);
            }
            catch (InstrumentException ex) {
                File oldProfileDir = new File(this.instanceProfileDir.getParentFile(), this.instanceProfileDir.getName() + ".old." + System.currentTimeMillis());
                if (this.instanceProfileDir.renameTo(oldProfileDir)) {
                    this.logger.warning("could not delete profileDir: " + ex.getMessage() + "; renamed it to " + oldProfileDir);
                }
                this.logger.severe("could not delete profileDir: " + ex.getMessage());
            }
        }
    }

    private void addBasisAndUrePaths(ProcessBuilder processBuilder) throws IOException {
        File basisLink = new File(this.officeHome, "basis-link");
        if (!basisLink.isFile()) {
            this.logger.fine("no %OFFICE_HOME%/basis-link found; assuming it's OOo 2.x and we don't need to append URE and Basic paths");
            return;
        }
        String basisLinkText = FileUtils.readFile(basisLink).trim();
        File basisHome = new File(this.officeHome, basisLinkText);
        File basisProgram = new File(basisHome, "program");
        File ureLink = new File(basisHome, "ure-link");
        String ureLinkText = FileUtils.readFile(ureLink).trim();
        File ureHome = new File(basisHome, ureLinkText);
        File ureBin = new File(ureHome, "bin");
        Map<String, String> environment = processBuilder.environment();
        String pathKey = "PATH";
        for (String key : environment.keySet()) {
            if (!"PATH".equalsIgnoreCase(key)) continue;
            pathKey = key;
        }
        String path = environment.get(pathKey) + ";" + ureBin.getAbsolutePath() + ";" + basisProgram.getAbsolutePath();
        this.logger.fine(String.format("setting %s to \"%s\"", pathKey, path));
        environment.put(pathKey, path);
    }

    public boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        return this.getExitCode() == null;
    }

    public Integer getExitCode() {
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException exception) {
            return null;
        }
    }

    public int getExitCode(long retryInterval, long retryTimeout) throws InstrumentException {
        try {
            ExitCodeRetryable retryable = new ExitCodeRetryable();
            retryable.execute(retryInterval, retryTimeout);
            return retryable.getExitCode();
        }
        catch (InstrumentException retryTimeoutException) {
            throw retryTimeoutException;
        }
        catch (Exception exception) {
            throw new InstrumentException("could not get process exit code", exception);
        }
    }

    public int forciblyTerminate(long retryInterval, long retryTimeout) throws IOException, InstrumentException {
        this.logger.info(String.format("trying to forcibly terminate process: '" + this.unoUrl + "'" + (this.pid != -1L ? " (pid " + this.pid + ")" : ""), new Object[0]));
        this.processManager.kill(this.process, this.pid);
        return this.getExitCode(retryInterval, retryTimeout);
    }

    private class ExitCodeRetryable
    extends Retryable {
        private int exitCode;

        private ExitCodeRetryable() {
        }

        @Override
        protected void attempt() throws Exception {
            try {
                this.exitCode = Process.this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                throw new InstrumentException(illegalThreadStateException);
            }
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

