/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office;

import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.util.XRefreshable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Storable;
import org.aoju.bus.office.magic.Formats;

public class Standard
extends Storable {
    private final Formats outputFormat;
    private Map<String, ?> defaultLoadProperties;
    private Formats inputFormat;

    public Standard(File inputFile, File outputFile, Formats outputFormat) {
        super(inputFile, outputFile);
        this.outputFormat = outputFormat;
    }

    public static Formats.Type getDocumentFamily(XComponent document) throws InstrumentException {
        XServiceInfo serviceInfo = Builder.cast(XServiceInfo.class, document);
        if (serviceInfo.supportsService("com.sun.star.text.GenericTextDocument")) {
            return Formats.Type.TEXT;
        }
        if (serviceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            return Formats.Type.SPREADSHEET;
        }
        if (serviceInfo.supportsService("com.sun.star.presentation.PresentationDocument")) {
            return Formats.Type.PRESENTATION;
        }
        if (serviceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            return Formats.Type.DRAWING;
        }
        throw new InstrumentException("document of unknown family: " + serviceInfo.getImplementationName());
    }

    public void setDefaultLoadProperties(Map<String, ?> defaultLoadProperties) {
        this.defaultLoadProperties = defaultLoadProperties;
    }

    public void setInputFormat(Formats inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Override
    protected void modifyDocument(XComponent document) throws InstrumentException {
        XRefreshable refreshable = Builder.cast(XRefreshable.class, document);
        if (refreshable != null) {
            refreshable.refresh();
        }
    }

    @Override
    protected Map<String, ?> getLoadProperties(File inputFile) {
        HashMap loadProperties = new HashMap();
        if (this.defaultLoadProperties != null) {
            loadProperties.putAll(this.defaultLoadProperties);
        }
        if (this.inputFormat != null && this.inputFormat.getLoadProperties() != null) {
            loadProperties.putAll(this.inputFormat.getLoadProperties());
        }
        return loadProperties;
    }

    @Override
    protected Map<String, ?> getStoreProperties(File outputFile, XComponent document) {
        Formats.Type family = Standard.getDocumentFamily(document);
        return this.outputFormat.getStoreProperties(family);
    }
}

