/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office;

import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.Office;

public abstract class Storable
implements Office {
    private final File inputFile;
    private final File outputFile;

    public Storable(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    protected abstract Map<String, ?> getLoadProperties(File var1);

    protected abstract Map<String, ?> getStoreProperties(File var1, XComponent var2);

    @Override
    public void execute(Context context) throws InstrumentException {
        XComponent document = null;
        try {
            document = this.loadDocument(context, this.inputFile);
            this.modifyDocument(document);
            this.storeDocument(document, this.outputFile);
        }
        catch (InstrumentException officeException) {
            throw officeException;
        }
        catch (Exception exception) {
            throw new InstrumentException("conversion failed", exception);
        }
        finally {
            if (document != null) {
                XCloseable closeable = Builder.cast(XCloseable.class, document);
                if (closeable != null) {
                    try {
                        closeable.close(true);
                    }
                    catch (CloseVetoException closeVetoException) {}
                } else {
                    document.dispose();
                }
            }
        }
    }

    private XComponent loadDocument(Context context, File inputFile) throws InstrumentException {
        if (!inputFile.exists()) {
            throw new InstrumentException("input document not found");
        }
        XComponentLoader loader = Builder.cast(XComponentLoader.class, context.getService("com.sun.star.frame.Desktop"));
        Map<String, ?> loadProperties = this.getLoadProperties(inputFile);
        XComponent document = null;
        try {
            document = loader.loadComponentFromURL(Builder.toUrl(inputFile), "_blank", 0, Builder.toUnoProperties(loadProperties));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InstrumentException("could not load document: " + inputFile.getName(), illegalArgumentException);
        }
        catch (ErrorCodeIOException errorCodeIOException) {
            throw new InstrumentException("could not load document: " + inputFile.getName() + "; errorCode: " + errorCodeIOException.ErrCode, errorCodeIOException);
        }
        catch (IOException ioException) {
            throw new InstrumentException("could not load document: " + inputFile.getName(), ioException);
        }
        if (document == null) {
            throw new InstrumentException("could not load document: " + inputFile.getName());
        }
        return document;
    }

    protected void modifyDocument(XComponent document) throws InstrumentException {
    }

    private void storeDocument(XComponent document, File outputFile) throws InstrumentException {
        Map<String, ?> storeProperties = this.getStoreProperties(outputFile, document);
        if (storeProperties == null) {
            throw new InstrumentException("unsupported conversion");
        }
        try {
            Builder.cast(XStorable.class, document).storeToURL(Builder.toUrl(outputFile), Builder.toUnoProperties(storeProperties));
        }
        catch (ErrorCodeIOException errorCodeIOException) {
            throw new InstrumentException("could not store document: " + outputFile.getName() + "; errorCode: " + errorCodeIOException.ErrCode, errorCodeIOException);
        }
        catch (IOException ioException) {
            throw new InstrumentException("could not store document: " + outputFile.getName(), ioException);
        }
    }
}

