/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.registry;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.aoju.bus.office.magic.Formats;
import org.aoju.bus.office.registry.SimpleFormatRegistry;

public class DefaultFormatRegistry
extends SimpleFormatRegistry {
    public DefaultFormatRegistry() {
        Formats pdf = new Formats("Portable Document Format", "pdf", "application/pdf");
        pdf.setStoreProperties(Formats.Type.TEXT, Collections.singletonMap("FilterName", "writer_pdf_Export"));
        pdf.setStoreProperties(Formats.Type.SPREADSHEET, Collections.singletonMap("FilterName", "calc_pdf_Export"));
        pdf.setStoreProperties(Formats.Type.PRESENTATION, Collections.singletonMap("FilterName", "impress_pdf_Export"));
        pdf.setStoreProperties(Formats.Type.DRAWING, Collections.singletonMap("FilterName", "draw_pdf_Export"));
        this.addFormat(pdf);
        Formats swf = new Formats("Macromedia Flash", "swf", "application/x-shockwave-flash");
        swf.setStoreProperties(Formats.Type.PRESENTATION, Collections.singletonMap("FilterName", "impress_flash_Export"));
        swf.setStoreProperties(Formats.Type.DRAWING, Collections.singletonMap("FilterName", "draw_flash_Export"));
        this.addFormat(swf);
        Formats html = new Formats("HTML", "html", "text/html");
        html.setInputFamily(Formats.Type.TEXT);
        html.setStoreProperties(Formats.Type.TEXT, Collections.singletonMap("FilterName", "HTML (StarWriter)"));
        html.setStoreProperties(Formats.Type.SPREADSHEET, Collections.singletonMap("FilterName", "HTML (StarCalc)"));
        html.setStoreProperties(Formats.Type.PRESENTATION, Collections.singletonMap("FilterName", "impress_html_Export"));
        this.addFormat(html);
        Formats odt = new Formats("OpenDocument Text", "odt", "application/vnd.oasis.opendocument.text");
        odt.setInputFamily(Formats.Type.TEXT);
        odt.setStoreProperties(Formats.Type.TEXT, Collections.singletonMap("FilterName", "writer8"));
        this.addFormat(odt);
        Formats sxw = new Formats("OpenOffice.org 1.0 Text Document", "sxw", "application/vnd.sun.xml.writer");
        sxw.setInputFamily(Formats.Type.TEXT);
        sxw.setStoreProperties(Formats.Type.TEXT, Collections.singletonMap("FilterName", "StarOffice XML (Writer)"));
        this.addFormat(sxw);
        Formats doc = new Formats("Microsoft Word", "doc", "application/msword");
        doc.setInputFamily(Formats.Type.TEXT);
        doc.setStoreProperties(Formats.Type.TEXT, Collections.singletonMap("FilterName", "MS Word 97"));
        this.addFormat(doc);
        Formats docx = new Formats("Microsoft Word 2007 XML", "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        docx.setInputFamily(Formats.Type.TEXT);
        this.addFormat(docx);
        Formats rtf = new Formats("Rich Text Format", "rtf", "text/rtf");
        rtf.setInputFamily(Formats.Type.TEXT);
        rtf.setStoreProperties(Formats.Type.TEXT, Collections.singletonMap("FilterName", "Rich Text Format"));
        this.addFormat(rtf);
        Formats wpd = new Formats("WordPerfect", "wpd", "application/wordperfect");
        wpd.setInputFamily(Formats.Type.TEXT);
        this.addFormat(wpd);
        Formats txt = new Formats("Plain Text", "txt", "text/plain");
        txt.setInputFamily(Formats.Type.TEXT);
        LinkedHashMap<String, String> txtLoadAndStoreProperties = new LinkedHashMap<String, String>();
        txtLoadAndStoreProperties.put("FilterName", "Text (encoded)");
        txtLoadAndStoreProperties.put("FilterOptions", "utf8");
        txt.setLoadProperties(txtLoadAndStoreProperties);
        txt.setStoreProperties(Formats.Type.TEXT, txtLoadAndStoreProperties);
        this.addFormat(txt);
        Formats wikitext = new Formats("MediaWiki wikitext", "wiki", "text/x-wiki");
        wikitext.setStoreProperties(Formats.Type.TEXT, Collections.singletonMap("FilterName", "MediaWiki"));
        Formats ods = new Formats("OpenDocument Spreadsheet", "ods", "application/vnd.oasis.opendocument.spreadsheet");
        ods.setInputFamily(Formats.Type.SPREADSHEET);
        ods.setStoreProperties(Formats.Type.SPREADSHEET, Collections.singletonMap("FilterName", "calc8"));
        this.addFormat(ods);
        Formats sxc = new Formats("OpenOffice.org 1.0 Spreadsheet", "sxc", "application/vnd.sun.xml.calc");
        sxc.setInputFamily(Formats.Type.SPREADSHEET);
        sxc.setStoreProperties(Formats.Type.SPREADSHEET, Collections.singletonMap("FilterName", "StarOffice XML (Calc)"));
        this.addFormat(sxc);
        Formats xls = new Formats("Microsoft Excel", "xls", "application/vnd.ms-excel");
        xls.setInputFamily(Formats.Type.SPREADSHEET);
        xls.setStoreProperties(Formats.Type.SPREADSHEET, Collections.singletonMap("FilterName", "MS Excel 97"));
        this.addFormat(xls);
        Formats xlsx = new Formats("Microsoft Excel 2007 XML", "xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        xlsx.setInputFamily(Formats.Type.SPREADSHEET);
        this.addFormat(xlsx);
        Formats csv = new Formats("Comma Separated Values", "csv", "text/csv");
        csv.setInputFamily(Formats.Type.SPREADSHEET);
        LinkedHashMap<String, String> csvLoadAndStoreProperties = new LinkedHashMap<String, String>();
        csvLoadAndStoreProperties.put("FilterName", "Text - txt - csv (StarCalc)");
        csvLoadAndStoreProperties.put("FilterOptions", "44,34,0");
        csv.setLoadProperties(csvLoadAndStoreProperties);
        csv.setStoreProperties(Formats.Type.SPREADSHEET, csvLoadAndStoreProperties);
        this.addFormat(csv);
        Formats tsv = new Formats("Tab Separated Values", "tsv", "text/tab-separated-values");
        tsv.setInputFamily(Formats.Type.SPREADSHEET);
        LinkedHashMap<String, String> tsvLoadAndStoreProperties = new LinkedHashMap<String, String>();
        tsvLoadAndStoreProperties.put("FilterName", "Text - txt - csv (StarCalc)");
        tsvLoadAndStoreProperties.put("FilterOptions", "9,34,0");
        tsv.setLoadProperties(tsvLoadAndStoreProperties);
        tsv.setStoreProperties(Formats.Type.SPREADSHEET, tsvLoadAndStoreProperties);
        this.addFormat(tsv);
        Formats odp = new Formats("OpenDocument Presentation", "odp", "application/vnd.oasis.opendocument.presentation");
        odp.setInputFamily(Formats.Type.PRESENTATION);
        odp.setStoreProperties(Formats.Type.PRESENTATION, Collections.singletonMap("FilterName", "impress8"));
        this.addFormat(odp);
        Formats sxi = new Formats("OpenOffice.org 1.0 Presentation", "sxi", "application/vnd.sun.xml.impress");
        sxi.setInputFamily(Formats.Type.PRESENTATION);
        sxi.setStoreProperties(Formats.Type.PRESENTATION, Collections.singletonMap("FilterName", "StarOffice XML (Impress)"));
        this.addFormat(sxi);
        Formats ppt = new Formats("Microsoft PowerPoint", "ppt", "application/vnd.ms-powerpoint");
        ppt.setInputFamily(Formats.Type.PRESENTATION);
        ppt.setStoreProperties(Formats.Type.PRESENTATION, Collections.singletonMap("FilterName", "MS PowerPoint 97"));
        this.addFormat(ppt);
        Formats pptx = new Formats("Microsoft PowerPoint 2007 XML", "pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        pptx.setInputFamily(Formats.Type.PRESENTATION);
        this.addFormat(pptx);
        Formats odg = new Formats("OpenDocument Drawing", "odg", "application/vnd.oasis.opendocument.graphics");
        odg.setInputFamily(Formats.Type.DRAWING);
        odg.setStoreProperties(Formats.Type.DRAWING, Collections.singletonMap("FilterName", "draw8"));
        this.addFormat(odg);
        Formats svg = new Formats("Scalable Vector Graphics", "svg", "image/svg+xml");
        svg.setStoreProperties(Formats.Type.DRAWING, Collections.singletonMap("FilterName", "draw_svg_Export"));
        this.addFormat(svg);
    }
}

